/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.CompatibleElasticsearchVersionsListCopier;
import software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCompatibleElasticsearchVersionsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, GetCompatibleElasticsearchVersionsResponse> {
    private static final SdkField<List<CompatibleVersionsMap>> COMPATIBLE_ELASTICSEARCH_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCompatibleElasticsearchVersionsResponse.getter(GetCompatibleElasticsearchVersionsResponse::compatibleElasticsearchVersions)).setter(GetCompatibleElasticsearchVersionsResponse.setter(Builder::compatibleElasticsearchVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleElasticsearchVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompatibleVersionsMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_ELASTICSEARCH_VERSIONS_FIELD));
    private final List<CompatibleVersionsMap> compatibleElasticsearchVersions;

    private GetCompatibleElasticsearchVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleElasticsearchVersions = builder.compatibleElasticsearchVersions;
    }

    public List<CompatibleVersionsMap> compatibleElasticsearchVersions() {
        return this.compatibleElasticsearchVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleElasticsearchVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCompatibleElasticsearchVersionsResponse)) {
            return false;
        }
        GetCompatibleElasticsearchVersionsResponse other = (GetCompatibleElasticsearchVersionsResponse)((Object)obj);
        return Objects.equals(this.compatibleElasticsearchVersions(), other.compatibleElasticsearchVersions());
    }

    public String toString() {
        return ToString.builder((String)"GetCompatibleElasticsearchVersionsResponse").add("CompatibleElasticsearchVersions", this.compatibleElasticsearchVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompatibleElasticsearchVersions": {
                return Optional.ofNullable(clazz.cast(this.compatibleElasticsearchVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCompatibleElasticsearchVersionsResponse, T> g) {
        return obj -> g.apply((GetCompatibleElasticsearchVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<CompatibleVersionsMap> compatibleElasticsearchVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCompatibleElasticsearchVersionsResponse model) {
            super(model);
            this.compatibleElasticsearchVersions(model.compatibleElasticsearchVersions);
        }

        public final Collection<CompatibleVersionsMap.Builder> getCompatibleElasticsearchVersions() {
            return this.compatibleElasticsearchVersions != null ? (Collection)this.compatibleElasticsearchVersions.stream().map(CompatibleVersionsMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleElasticsearchVersions(Collection<CompatibleVersionsMap> compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions = CompatibleElasticsearchVersionsListCopier.copy(compatibleElasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleElasticsearchVersions(CompatibleVersionsMap ... compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions(Arrays.asList(compatibleElasticsearchVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleElasticsearchVersions(Consumer<CompatibleVersionsMap.Builder> ... compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions(Stream.of(compatibleElasticsearchVersions).map(c -> (CompatibleVersionsMap)((CompatibleVersionsMap.Builder)CompatibleVersionsMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleElasticsearchVersions(Collection<CompatibleVersionsMap.BuilderImpl> compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions = CompatibleElasticsearchVersionsListCopier.copyFromBuilder(compatibleElasticsearchVersions);
        }

        @Override
        public GetCompatibleElasticsearchVersionsResponse build() {
            return new GetCompatibleElasticsearchVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCompatibleElasticsearchVersionsResponse> {
        public Builder compatibleElasticsearchVersions(Collection<CompatibleVersionsMap> var1);

        public Builder compatibleElasticsearchVersions(CompatibleVersionsMap ... var1);

        public Builder compatibleElasticsearchVersions(Consumer<CompatibleVersionsMap.Builder> ... var1);
    }
}

