/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.IssuesCopier;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStep;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeStepItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpgradeStepItem> {
    private static final SdkField<String> UPGRADE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeStepItem.getter(UpgradeStepItem::upgradeStepAsString)).setter(UpgradeStepItem.setter(Builder::upgradeStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStep").build()}).build();
    private static final SdkField<String> UPGRADE_STEP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeStepItem.getter(UpgradeStepItem::upgradeStepStatusAsString)).setter(UpgradeStepItem.setter(Builder::upgradeStepStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStepStatus").build()}).build();
    private static final SdkField<List<String>> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpgradeStepItem.getter(UpgradeStepItem::issues)).setter(UpgradeStepItem.setter(Builder::issues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(UpgradeStepItem.getter(UpgradeStepItem::progressPercent)).setter(UpgradeStepItem.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_STEP_FIELD, UPGRADE_STEP_STATUS_FIELD, ISSUES_FIELD, PROGRESS_PERCENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String upgradeStep;
    private final String upgradeStepStatus;
    private final List<String> issues;
    private final Double progressPercent;

    private UpgradeStepItem(BuilderImpl builder) {
        this.upgradeStep = builder.upgradeStep;
        this.upgradeStepStatus = builder.upgradeStepStatus;
        this.issues = builder.issues;
        this.progressPercent = builder.progressPercent;
    }

    public UpgradeStep upgradeStep() {
        return UpgradeStep.fromValue(this.upgradeStep);
    }

    public String upgradeStepAsString() {
        return this.upgradeStep;
    }

    public UpgradeStatus upgradeStepStatus() {
        return UpgradeStatus.fromValue(this.upgradeStepStatus);
    }

    public String upgradeStepStatusAsString() {
        return this.upgradeStepStatus;
    }

    public List<String> issues() {
        return this.issues;
    }

    public Double progressPercent() {
        return this.progressPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStepAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issues());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeStepItem)) {
            return false;
        }
        UpgradeStepItem other = (UpgradeStepItem)obj;
        return Objects.equals(this.upgradeStepAsString(), other.upgradeStepAsString()) && Objects.equals(this.upgradeStepStatusAsString(), other.upgradeStepStatusAsString()) && Objects.equals(this.issues(), other.issues()) && Objects.equals(this.progressPercent(), other.progressPercent());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeStepItem").add("UpgradeStep", (Object)this.upgradeStepAsString()).add("UpgradeStepStatus", (Object)this.upgradeStepStatusAsString()).add("Issues", this.issues()).add("ProgressPercent", (Object)this.progressPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeStep": {
                return Optional.ofNullable(clazz.cast(this.upgradeStepAsString()));
            }
            case "UpgradeStepStatus": {
                return Optional.ofNullable(clazz.cast(this.upgradeStepStatusAsString()));
            }
            case "Issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeStepItem, T> g) {
        return obj -> g.apply((UpgradeStepItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String upgradeStep;
        private String upgradeStepStatus;
        private List<String> issues = DefaultSdkAutoConstructList.getInstance();
        private Double progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeStepItem model) {
            this.upgradeStep(model.upgradeStep);
            this.upgradeStepStatus(model.upgradeStepStatus);
            this.issues(model.issues);
            this.progressPercent(model.progressPercent);
        }

        public final String getUpgradeStepAsString() {
            return this.upgradeStep;
        }

        @Override
        public final Builder upgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
            return this;
        }

        @Override
        public final Builder upgradeStep(UpgradeStep upgradeStep) {
            this.upgradeStep(upgradeStep.toString());
            return this;
        }

        public final void setUpgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
        }

        public final String getUpgradeStepStatusAsString() {
            return this.upgradeStepStatus;
        }

        @Override
        public final Builder upgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
            return this;
        }

        @Override
        public final Builder upgradeStepStatus(UpgradeStatus upgradeStepStatus) {
            this.upgradeStepStatus(upgradeStepStatus.toString());
            return this;
        }

        public final void setUpgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
        }

        public final Collection<String> getIssues() {
            return this.issues;
        }

        @Override
        public final Builder issues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(String ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        public final void setIssues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
        }

        public final Double getProgressPercent() {
            return this.progressPercent;
        }

        @Override
        public final Builder progressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final void setProgressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
        }

        public UpgradeStepItem build() {
            return new UpgradeStepItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpgradeStepItem> {
        public Builder upgradeStep(String var1);

        public Builder upgradeStep(UpgradeStep var1);

        public Builder upgradeStepStatus(String var1);

        public Builder upgradeStepStatus(UpgradeStatus var1);

        public Builder issues(Collection<String> var1);

        public Builder issues(String ... var1);

        public Builder progressPercent(Double var1);
    }
}

