/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneDesiredState;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceScheduleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoTuneOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoTuneOptionsInput> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(AutoTuneOptionsInput.getter(AutoTuneOptionsInput::desiredStateAsString)).setter(AutoTuneOptionsInput.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<List<AutoTuneMaintenanceSchedule>> MAINTENANCE_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MaintenanceSchedules").getter(AutoTuneOptionsInput.getter(AutoTuneOptionsInput::maintenanceSchedules)).setter(AutoTuneOptionsInput.setter(Builder::maintenanceSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceSchedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoTuneMaintenanceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD, MAINTENANCE_SCHEDULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoTuneOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String desiredState;
    private final List<AutoTuneMaintenanceSchedule> maintenanceSchedules;

    private AutoTuneOptionsInput(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.maintenanceSchedules = builder.maintenanceSchedules;
    }

    public final AutoTuneDesiredState desiredState() {
        return AutoTuneDesiredState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final boolean hasMaintenanceSchedules() {
        return this.maintenanceSchedules != null && !(this.maintenanceSchedules instanceof SdkAutoConstructList);
    }

    public final List<AutoTuneMaintenanceSchedule> maintenanceSchedules() {
        return this.maintenanceSchedules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaintenanceSchedules() ? this.maintenanceSchedules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneOptionsInput)) {
            return false;
        }
        AutoTuneOptionsInput other = (AutoTuneOptionsInput)obj;
        return Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && this.hasMaintenanceSchedules() == other.hasMaintenanceSchedules() && Objects.equals(this.maintenanceSchedules(), other.maintenanceSchedules());
    }

    public final String toString() {
        return ToString.builder((String)"AutoTuneOptionsInput").add("DesiredState", (Object)this.desiredStateAsString()).add("MaintenanceSchedules", this.hasMaintenanceSchedules() ? this.maintenanceSchedules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "MaintenanceSchedules": {
                return Optional.ofNullable(clazz.cast(this.maintenanceSchedules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("MaintenanceSchedules", MAINTENANCE_SCHEDULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneOptionsInput, T> g) {
        return obj -> g.apply((AutoTuneOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String desiredState;
        private List<AutoTuneMaintenanceSchedule> maintenanceSchedules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneOptionsInput model) {
            this.desiredState(model.desiredState);
            this.maintenanceSchedules(model.maintenanceSchedules);
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(AutoTuneDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final List<AutoTuneMaintenanceSchedule.Builder> getMaintenanceSchedules() {
            List<AutoTuneMaintenanceSchedule.Builder> result = AutoTuneMaintenanceScheduleListCopier.copyToBuilder(this.maintenanceSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceSchedules(Collection<AutoTuneMaintenanceSchedule.BuilderImpl> maintenanceSchedules) {
            this.maintenanceSchedules = AutoTuneMaintenanceScheduleListCopier.copyFromBuilder(maintenanceSchedules);
        }

        @Override
        public final Builder maintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> maintenanceSchedules) {
            this.maintenanceSchedules = AutoTuneMaintenanceScheduleListCopier.copy(maintenanceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceSchedules(AutoTuneMaintenanceSchedule ... maintenanceSchedules) {
            this.maintenanceSchedules(Arrays.asList(maintenanceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceSchedules(Consumer<AutoTuneMaintenanceSchedule.Builder> ... maintenanceSchedules) {
            this.maintenanceSchedules(Stream.of(maintenanceSchedules).map(c -> (AutoTuneMaintenanceSchedule)((AutoTuneMaintenanceSchedule.Builder)AutoTuneMaintenanceSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutoTuneOptionsInput build() {
            return new AutoTuneOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoTuneOptionsInput> {
        public Builder desiredState(String var1);

        public Builder desiredState(AutoTuneDesiredState var1);

        public Builder maintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> var1);

        public Builder maintenanceSchedules(AutoTuneMaintenanceSchedule ... var1);

        public Builder maintenanceSchedules(Consumer<AutoTuneMaintenanceSchedule.Builder> ... var1);
    }
}

