/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;

public class DescribeInboundCrossClusterSearchConnectionsIterable
implements SdkIterable<DescribeInboundCrossClusterSearchConnectionsResponse> {
    private final ElasticsearchClient client;
    private final DescribeInboundCrossClusterSearchConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInboundCrossClusterSearchConnectionsIterable(ElasticsearchClient client, DescribeInboundCrossClusterSearchConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInboundCrossClusterSearchConnectionsResponseFetcher();
    }

    public Iterator<DescribeInboundCrossClusterSearchConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeInboundCrossClusterSearchConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeInboundCrossClusterSearchConnectionsResponse> {
        private DescribeInboundCrossClusterSearchConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundCrossClusterSearchConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInboundCrossClusterSearchConnectionsResponse nextPage(DescribeInboundCrossClusterSearchConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundCrossClusterSearchConnectionsIterable.this.client.describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsIterable.this.firstRequest);
            }
            return DescribeInboundCrossClusterSearchConnectionsIterable.this.client.describeInboundCrossClusterSearchConnections((DescribeInboundCrossClusterSearchConnectionsRequest)((Object)DescribeInboundCrossClusterSearchConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

