/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeElasticsearchDomainResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, UpgradeElasticsearchDomainResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpgradeElasticsearchDomainResponse.getter(UpgradeElasticsearchDomainResponse::domainName)).setter(UpgradeElasticsearchDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVersion").getter(UpgradeElasticsearchDomainResponse.getter(UpgradeElasticsearchDomainResponse::targetVersion)).setter(UpgradeElasticsearchDomainResponse.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformCheckOnly").getter(UpgradeElasticsearchDomainResponse.getter(UpgradeElasticsearchDomainResponse::performCheckOnly)).setter(UpgradeElasticsearchDomainResponse.setter(Builder::performCheckOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()}).build();
    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeProgressDetails").getter(UpgradeElasticsearchDomainResponse.getter(UpgradeElasticsearchDomainResponse::changeProgressDetails)).setter(UpgradeElasticsearchDomainResponse.setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD, CHANGE_PROGRESS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("TargetVersion", TARGET_VERSION_FIELD);
            this.put("PerformCheckOnly", PERFORM_CHECK_ONLY_FIELD);
            this.put("ChangeProgressDetails", CHANGE_PROGRESS_DETAILS_FIELD);
        }
    });
    private final String domainName;
    private final String targetVersion;
    private final Boolean performCheckOnly;
    private final ChangeProgressDetails changeProgressDetails;

    private UpgradeElasticsearchDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
        this.changeProgressDetails = builder.changeProgressDetails;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final Boolean performCheckOnly() {
        return this.performCheckOnly;
    }

    public final ChangeProgressDetails changeProgressDetails() {
        return this.changeProgressDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performCheckOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeProgressDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeElasticsearchDomainResponse)) {
            return false;
        }
        UpgradeElasticsearchDomainResponse other = (UpgradeElasticsearchDomainResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.performCheckOnly(), other.performCheckOnly()) && Objects.equals(this.changeProgressDetails(), other.changeProgressDetails());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeElasticsearchDomainResponse").add("DomainName", (Object)this.domainName()).add("TargetVersion", (Object)this.targetVersion()).add("PerformCheckOnly", (Object)this.performCheckOnly()).add("ChangeProgressDetails", (Object)this.changeProgressDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "PerformCheckOnly": {
                return Optional.ofNullable(clazz.cast(this.performCheckOnly()));
            }
            case "ChangeProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.changeProgressDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeElasticsearchDomainResponse, T> g) {
        return obj -> g.apply((UpgradeElasticsearchDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String targetVersion;
        private Boolean performCheckOnly;
        private ChangeProgressDetails changeProgressDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeElasticsearchDomainResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.targetVersion(model.targetVersion);
            this.performCheckOnly(model.performCheckOnly);
            this.changeProgressDetails(model.changeProgressDetails);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return this.performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return this.changeProgressDetails != null ? this.changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        @Override
        public UpgradeElasticsearchDomainResponse build() {
            return new UpgradeElasticsearchDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeElasticsearchDomainResponse> {
        public Builder domainName(String var1);

        public Builder targetVersion(String var1);

        public Builder performCheckOnly(Boolean var1);

        public Builder changeProgressDetails(ChangeProgressDetails var1);

        default public Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return this.changeProgressDetails((ChangeProgressDetails)((ChangeProgressDetails.Builder)ChangeProgressDetails.builder().applyMutation(changeProgressDetails)).build());
        }
    }
}

