/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;
import software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.services.elasticsearch.model.VPCOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateElasticsearchDomainConfigRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::domainName)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<ElasticsearchClusterConfig> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchClusterConfig").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::elasticsearchClusterConfig)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::elasticsearchClusterConfig)).constructor(ElasticsearchClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::ebsOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::ebsOptions)).constructor(EBSOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::snapshotOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::snapshotOptions)).constructor(SnapshotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::vpcOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::vpcOptions)).constructor(VPCOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::cognitoOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::cognitoOptions)).constructor(CognitoOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdvancedOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::advancedOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::accessPolicies)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogPublishingOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::logPublishingOptionsAsStrings)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::logPublishingOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::domainEndpointOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptionsInput> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::advancedSecurityOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::nodeToNodeEncryptionOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::encryptionAtRestOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<AutoTuneOptions> AUTO_TUNE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneOptions").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::autoTuneOptions)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::autoTuneOptions)).constructor(AutoTuneOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UpdateElasticsearchDomainConfigRequest.getter(UpdateElasticsearchDomainConfigRequest::dryRun)).setter(UpdateElasticsearchDomainConfigRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, AUTO_TUNE_OPTIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ElasticsearchClusterConfig", ELASTICSEARCH_CLUSTER_CONFIG_FIELD);
            this.put("EBSOptions", EBS_OPTIONS_FIELD);
            this.put("SnapshotOptions", SNAPSHOT_OPTIONS_FIELD);
            this.put("VPCOptions", VPC_OPTIONS_FIELD);
            this.put("CognitoOptions", COGNITO_OPTIONS_FIELD);
            this.put("AdvancedOptions", ADVANCED_OPTIONS_FIELD);
            this.put("AccessPolicies", ACCESS_POLICIES_FIELD);
            this.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
            this.put("DomainEndpointOptions", DOMAIN_ENDPOINT_OPTIONS_FIELD);
            this.put("AdvancedSecurityOptions", ADVANCED_SECURITY_OPTIONS_FIELD);
            this.put("NodeToNodeEncryptionOptions", NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD);
            this.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
            this.put("AutoTuneOptions", AUTO_TUNE_OPTIONS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String domainName;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final SnapshotOptions snapshotOptions;
    private final VPCOptions vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final Map<String, String> advancedOptions;
    private final String accessPolicies;
    private final Map<String, LogPublishingOption> logPublishingOptions;
    private final DomainEndpointOptions domainEndpointOptions;
    private final AdvancedSecurityOptionsInput advancedSecurityOptions;
    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final AutoTuneOptions autoTuneOptions;
    private final Boolean dryRun;

    private UpdateElasticsearchDomainConfigRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.advancedOptions = builder.advancedOptions;
        this.accessPolicies = builder.accessPolicies;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.dryRun = builder.dryRun;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public final EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public final SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public final VPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public final CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public final String accessPolicies() {
        return this.accessPolicies;
    }

    public final Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.logPublishingOptions);
    }

    public final boolean hasLogPublishingOptions() {
        return this.logPublishingOptions != null && !(this.logPublishingOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    public final DomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AdvancedSecurityOptionsInput advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final AutoTuneOptions autoTuneOptions() {
        return this.autoTuneOptions;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateElasticsearchDomainConfigRequest)) {
            return false;
        }
        UpdateElasticsearchDomainConfigRequest other = (UpdateElasticsearchDomainConfigRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && this.hasLogPublishingOptions() == other.hasLogPublishingOptions() && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.autoTuneOptions(), other.autoTuneOptions()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateElasticsearchDomainConfigRequest").add("DomainName", (Object)this.domainName()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).add("AccessPolicies", (Object)this.accessPolicies()).add("LogPublishingOptions", this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("AutoTuneOptions", (Object)this.autoTuneOptions()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "AutoTuneOptions": {
                return Optional.ofNullable(clazz.cast(this.autoTuneOptions()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateElasticsearchDomainConfigRequest, T> g) {
        return obj -> g.apply((UpdateElasticsearchDomainConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private SnapshotOptions snapshotOptions;
        private VPCOptions vpcOptions;
        private CognitoOptions cognitoOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private String accessPolicies;
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();
        private DomainEndpointOptions domainEndpointOptions;
        private AdvancedSecurityOptionsInput advancedSecurityOptions;
        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private AutoTuneOptions autoTuneOptions;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateElasticsearchDomainConfigRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.advancedOptions(model.advancedOptions);
            this.accessPolicies(model.accessPolicies);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.autoTuneOptions(model.autoTuneOptions);
            this.dryRun(model.dryRun);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (this.advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.logPublishingOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsInput.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsInput.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final AutoTuneOptions.Builder getAutoTuneOptions() {
            return this.autoTuneOptions != null ? this.autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptions.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptions autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateElasticsearchDomainConfigRequest build() {
            return new UpdateElasticsearchDomainConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
        public Builder domainName(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfig.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCOptions var1);

        default public Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((VPCOptions)((VPCOptions.Builder)VPCOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder accessPolicies(String var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder domainEndpointOptions(DomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptions)((DomainEndpointOptions.Builder)DomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptionsInput var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsInput.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptionsInput)((AdvancedSecurityOptionsInput.Builder)AdvancedSecurityOptionsInput.builder().applyMutation(advancedSecurityOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptions)((NodeToNodeEncryptionOptions.Builder)NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder autoTuneOptions(AutoTuneOptions var1);

        default public Builder autoTuneOptions(Consumer<AutoTuneOptions.Builder> autoTuneOptions) {
            return this.autoTuneOptions((AutoTuneOptions)((AutoTuneOptions.Builder)AutoTuneOptions.builder().applyMutation(autoTuneOptions)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

