/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.PropertyValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyingProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyingProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ModifyingProperties.getter(ModifyingProperties::name)).setter(ModifyingProperties.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ACTIVE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveValue").getter(ModifyingProperties.getter(ModifyingProperties::activeValue)).setter(ModifyingProperties.setter(Builder::activeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveValue").build()}).build();
    private static final SdkField<String> PENDING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingValue").getter(ModifyingProperties.getter(ModifyingProperties::pendingValue)).setter(ModifyingProperties.setter(Builder::pendingValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingValue").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(ModifyingProperties.getter(ModifyingProperties::valueTypeAsString)).setter(ModifyingProperties.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTIVE_VALUE_FIELD, PENDING_VALUE_FIELD, VALUE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("ActiveValue", ACTIVE_VALUE_FIELD);
            this.put("PendingValue", PENDING_VALUE_FIELD);
            this.put("ValueType", VALUE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String activeValue;
    private final String pendingValue;
    private final String valueType;

    private ModifyingProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.activeValue = builder.activeValue;
        this.pendingValue = builder.pendingValue;
        this.valueType = builder.valueType;
    }

    public final String name() {
        return this.name;
    }

    public final String activeValue() {
        return this.activeValue;
    }

    public final String pendingValue() {
        return this.pendingValue;
    }

    public final PropertyValueType valueType() {
        return PropertyValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyingProperties)) {
            return false;
        }
        ModifyingProperties other = (ModifyingProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.activeValue(), other.activeValue()) && Objects.equals(this.pendingValue(), other.pendingValue()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyingProperties").add("Name", (Object)this.name()).add("ActiveValue", (Object)this.activeValue()).add("PendingValue", (Object)this.pendingValue()).add("ValueType", (Object)this.valueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ActiveValue": {
                return Optional.ofNullable(clazz.cast(this.activeValue()));
            }
            case "PendingValue": {
                return Optional.ofNullable(clazz.cast(this.pendingValue()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyingProperties, T> g) {
        return obj -> g.apply((ModifyingProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String activeValue;
        private String pendingValue;
        private String valueType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyingProperties model) {
            this.name(model.name);
            this.activeValue(model.activeValue);
            this.pendingValue(model.pendingValue);
            this.valueType(model.valueType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActiveValue() {
            return this.activeValue;
        }

        public final void setActiveValue(String activeValue) {
            this.activeValue = activeValue;
        }

        @Override
        public final Builder activeValue(String activeValue) {
            this.activeValue = activeValue;
            return this;
        }

        public final String getPendingValue() {
            return this.pendingValue;
        }

        public final void setPendingValue(String pendingValue) {
            this.pendingValue = pendingValue;
        }

        @Override
        public final Builder pendingValue(String pendingValue) {
            this.pendingValue = pendingValue;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(PropertyValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public ModifyingProperties build() {
            return new ModifyingProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyingProperties> {
        public Builder name(String var1);

        public Builder activeValue(String var1);

        public Builder pendingValue(String var1);

        public Builder valueType(String var1);

        public Builder valueType(PropertyValueType var1);
    }
}

