/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpoint> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(VpcEndpoint.getter(VpcEndpoint::vpcEndpointId)).setter(VpcEndpoint.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointOwner").getter(VpcEndpoint.getter(VpcEndpoint::vpcEndpointOwner)).setter(VpcEndpoint.setter(Builder::vpcEndpointOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointOwner").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainArn").getter(VpcEndpoint.getter(VpcEndpoint::domainArn)).setter(VpcEndpoint.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()}).build();
    private static final SdkField<VPCDerivedInfo> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOptions").getter(VpcEndpoint.getter(VpcEndpoint::vpcOptions)).setter(VpcEndpoint.setter(Builder::vpcOptions)).constructor(VPCDerivedInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VpcEndpoint.getter(VpcEndpoint::statusAsString)).setter(VpcEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(VpcEndpoint.getter(VpcEndpoint::endpoint)).setter(VpcEndpoint.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD, DOMAIN_ARN_FIELD, VPC_OPTIONS_FIELD, STATUS_FIELD, ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
            this.put("VpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
            this.put("DomainArn", DOMAIN_ARN_FIELD);
            this.put("VpcOptions", VPC_OPTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Endpoint", ENDPOINT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointId;
    private final String vpcEndpointOwner;
    private final String domainArn;
    private final VPCDerivedInfo vpcOptions;
    private final String status;
    private final String endpoint;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
        this.domainArn = builder.domainArn;
        this.vpcOptions = builder.vpcOptions;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String vpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final VPCDerivedInfo vpcOptions() {
        return this.vpcOptions;
    }

    public final VpcEndpointStatus status() {
        return VpcEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointOwner(), other.vpcEndpointOwner()) && Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endpoint(), other.endpoint());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEndpoint").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointOwner", (Object)this.vpcEndpointOwner()).add("DomainArn", (Object)this.domainArn()).add("VpcOptions", (Object)this.vpcOptions()).add("Status", (Object)this.statusAsString()).add("Endpoint", (Object)this.endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointOwner": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointOwner()));
            }
            case "DomainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "VpcOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpoint, T> g) {
        return obj -> g.apply((VpcEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String vpcEndpointOwner;
        private String domainArn;
        private VPCDerivedInfo vpcOptions;
        private String status;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointOwner(model.vpcEndpointOwner);
            this.domainArn(model.domainArn);
            this.vpcOptions(model.vpcOptions);
            this.status(model.status);
            this.endpoint(model.endpoint);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return this.vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final VPCDerivedInfo.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpoint> {
        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointOwner(String var1);

        public Builder domainArn(String var1);

        public Builder vpcOptions(VPCDerivedInfo var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfo)((VPCDerivedInfo.Builder)VPCDerivedInfo.builder().applyMutation(vpcOptions)).build());
        }

        public Builder status(String var1);

        public Builder status(VpcEndpointStatus var1);

        public Builder endpoint(String var1);
    }
}

