/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;

public class DescribeReservedElasticsearchInstanceOfferingsPublisher
implements SdkPublisher<DescribeReservedElasticsearchInstanceOfferingsResponse> {
    private final ElasticsearchAsyncClient client;
    private final DescribeReservedElasticsearchInstanceOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedElasticsearchInstanceOfferingsPublisher(ElasticsearchAsyncClient client, DescribeReservedElasticsearchInstanceOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedElasticsearchInstanceOfferingsPublisher(ElasticsearchAsyncClient client, DescribeReservedElasticsearchInstanceOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedElasticsearchInstanceOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedElasticsearchInstanceOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReservedElasticsearchInstanceOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedElasticsearchInstanceOfferingsResponse> {
        private DescribeReservedElasticsearchInstanceOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedElasticsearchInstanceOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> nextPage(DescribeReservedElasticsearchInstanceOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedElasticsearchInstanceOfferingsPublisher.this.client.describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedElasticsearchInstanceOfferingsPublisher.this.client.describeReservedElasticsearchInstanceOfferings((DescribeReservedElasticsearchInstanceOfferingsRequest)((Object)DescribeReservedElasticsearchInstanceOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

