/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.DomainNameListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchDomainsRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
    private static final SdkField<List<String>> DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainNames").getter(DescribeElasticsearchDomainsRequest.getter(DescribeElasticsearchDomainsRequest::domainNames)).setter(DescribeElasticsearchDomainsRequest.setter(Builder::domainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAMES_FIELD));
    private final List<String> domainNames;

    private DescribeElasticsearchDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    public final boolean hasDomainNames() {
        return this.domainNames != null && !(this.domainNames instanceof SdkAutoConstructList);
    }

    public final List<String> domainNames() {
        return this.domainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNames() ? this.domainNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsRequest)) {
            return false;
        }
        DescribeElasticsearchDomainsRequest other = (DescribeElasticsearchDomainsRequest)((Object)obj);
        return this.hasDomainNames() == other.hasDomainNames() && Objects.equals(this.domainNames(), other.domainNames());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeElasticsearchDomainsRequest").add("DomainNames", this.hasDomainNames() ? this.domainNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchDomainsRequest, T> g) {
        return obj -> g.apply((DescribeElasticsearchDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private List<String> domainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsRequest model) {
            super(model);
            this.domainNames(model.domainNames);
        }

        public final Collection<String> getDomainNames() {
            if (this.domainNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainNames;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticsearchDomainsRequest build() {
            return new DescribeElasticsearchDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

