/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.RecurringCharge;
import software.amazon.awssdk.services.elasticsearch.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedElasticsearchInstanceOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedElasticsearchInstanceOffering> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedElasticsearchInstanceOfferingId").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::reservedElasticsearchInstanceOfferingId)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::reservedElasticsearchInstanceOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceOfferingId").build()}).build();
    private static final SdkField<String> ELASTICSEARCH_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticsearchInstanceType").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::elasticsearchInstanceTypeAsString)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::elasticsearchInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceType").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::duration)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::fixedPrice)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::usagePrice)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::currencyCode)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::paymentOptionAsString)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedElasticsearchInstanceOffering.getter(ReservedElasticsearchInstanceOffering::recurringCharges)).setter(ReservedElasticsearchInstanceOffering.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD, ELASTICSEARCH_INSTANCE_TYPE_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservedElasticsearchInstanceOfferingId;
    private final String elasticsearchInstanceType;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final String paymentOption;
    private final List<RecurringCharge> recurringCharges;

    private ReservedElasticsearchInstanceOffering(BuilderImpl builder) {
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.elasticsearchInstanceType = builder.elasticsearchInstanceType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    public final String reservedElasticsearchInstanceOfferingId() {
        return this.reservedElasticsearchInstanceOfferingId;
    }

    public final ESPartitionInstanceType elasticsearchInstanceType() {
        return ESPartitionInstanceType.fromValue(this.elasticsearchInstanceType);
    }

    public final String elasticsearchInstanceTypeAsString() {
        return this.elasticsearchInstanceType;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final ReservedElasticsearchInstancePaymentOption paymentOption() {
        return ReservedElasticsearchInstancePaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedElasticsearchInstanceOffering)) {
            return false;
        }
        ReservedElasticsearchInstanceOffering other = (ReservedElasticsearchInstanceOffering)obj;
        return Objects.equals(this.reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId()) && Objects.equals(this.elasticsearchInstanceTypeAsString(), other.elasticsearchInstanceTypeAsString()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedElasticsearchInstanceOffering").add("ReservedElasticsearchInstanceOfferingId", (Object)this.reservedElasticsearchInstanceOfferingId()).add("ElasticsearchInstanceType", (Object)this.elasticsearchInstanceTypeAsString()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedElasticsearchInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferingId()));
            }
            case "ElasticsearchInstanceType": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchInstanceTypeAsString()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedElasticsearchInstanceOffering, T> g) {
        return obj -> g.apply((ReservedElasticsearchInstanceOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedElasticsearchInstanceOfferingId;
        private String elasticsearchInstanceType;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private String paymentOption;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedElasticsearchInstanceOffering model) {
            this.reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            this.elasticsearchInstanceType(model.elasticsearchInstanceType);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.paymentOption(model.paymentOption);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return this.reservedElasticsearchInstanceOfferingId;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        @Override
        @Transient
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final String getElasticsearchInstanceType() {
            return this.elasticsearchInstanceType;
        }

        public final void setElasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
        }

        @Override
        @Transient
        public final Builder elasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType) {
            this.elasticsearchInstanceType(elasticsearchInstanceType == null ? null : elasticsearchInstanceType.toString());
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        @Transient
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        @Transient
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        @Transient
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReservedElasticsearchInstanceOffering build() {
            return new ReservedElasticsearchInstanceOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedElasticsearchInstanceOffering> {
        public Builder reservedElasticsearchInstanceOfferingId(String var1);

        public Builder elasticsearchInstanceType(String var1);

        public Builder elasticsearchInstanceType(ESPartitionInstanceType var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(ReservedElasticsearchInstancePaymentOption var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

