/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVersionHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVersionHistory> {
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(PackageVersionHistory.getter(PackageVersionHistory::packageVersion)).setter(PackageVersionHistory.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitMessage").getter(PackageVersionHistory.getter(PackageVersionHistory::commitMessage)).setter(PackageVersionHistory.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(PackageVersionHistory.getter(PackageVersionHistory::createdAt)).setter(PackageVersionHistory.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD, COMMIT_MESSAGE_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packageVersion;
    private final String commitMessage;
    private final Instant createdAt;

    private PackageVersionHistory(BuilderImpl builder) {
        this.packageVersion = builder.packageVersion;
        this.commitMessage = builder.commitMessage;
        this.createdAt = builder.createdAt;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String commitMessage() {
        return this.commitMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionHistory)) {
            return false;
        }
        PackageVersionHistory other = (PackageVersionHistory)obj;
        return Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVersionHistory").add("PackageVersion", (Object)this.packageVersion()).add("CommitMessage", (Object)this.commitMessage()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "CommitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionHistory, T> g) {
        return obj -> g.apply((PackageVersionHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageVersion;
        private String commitMessage;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionHistory model) {
            this.packageVersion(model.packageVersion);
            this.commitMessage(model.commitMessage);
            this.createdAt(model.createdAt);
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        @Transient
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public PackageVersionHistory build() {
            return new PackageVersionHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVersionHistory> {
        public Builder packageVersion(String var1);

        public Builder commitMessage(String var1);

        public Builder createdAt(Instant var1);
    }
}

