/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoTuneState {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    ENABLE_IN_PROGRESS("ENABLE_IN_PROGRESS"),
    DISABLE_IN_PROGRESS("DISABLE_IN_PROGRESS"),
    DISABLED_AND_ROLLBACK_SCHEDULED("DISABLED_AND_ROLLBACK_SCHEDULED"),
    DISABLED_AND_ROLLBACK_IN_PROGRESS("DISABLED_AND_ROLLBACK_IN_PROGRESS"),
    DISABLED_AND_ROLLBACK_COMPLETE("DISABLED_AND_ROLLBACK_COMPLETE"),
    DISABLED_AND_ROLLBACK_ERROR("DISABLED_AND_ROLLBACK_ERROR"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoTuneState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoTuneState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoTuneState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoTuneState> knownValues() {
        return Stream.of(AutoTuneState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

