/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions;
import software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedSecurityOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedSecurityOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::enabled)).setter(AdvancedSecurityOptionsInput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InternalUserDatabaseEnabled").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::internalUserDatabaseEnabled)).setter(AdvancedSecurityOptionsInput.setter(Builder::internalUserDatabaseEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled").build()}).build();
    private static final SdkField<MasterUserOptions> MASTER_USER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MasterUserOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::masterUserOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::masterUserOptions)).constructor(MasterUserOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserOptions").build()}).build();
    private static final SdkField<SAMLOptionsInput> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SAMLOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::samlOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::samlOptions)).constructor(SAMLOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERNAL_USER_DATABASE_ENABLED_FIELD, MASTER_USER_OPTIONS_FIELD, SAML_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean internalUserDatabaseEnabled;
    private final MasterUserOptions masterUserOptions;
    private final SAMLOptionsInput samlOptions;

    private AdvancedSecurityOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.masterUserOptions = builder.masterUserOptions;
        this.samlOptions = builder.samlOptions;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean internalUserDatabaseEnabled() {
        return this.internalUserDatabaseEnabled;
    }

    public final MasterUserOptions masterUserOptions() {
        return this.masterUserOptions;
    }

    public final SAMLOptionsInput samlOptions() {
        return this.samlOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptionsInput)) {
            return false;
        }
        AdvancedSecurityOptionsInput other = (AdvancedSecurityOptionsInput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled()) && Objects.equals(this.masterUserOptions(), other.masterUserOptions()) && Objects.equals(this.samlOptions(), other.samlOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AdvancedSecurityOptionsInput").add("Enabled", (Object)this.enabled()).add("InternalUserDatabaseEnabled", (Object)this.internalUserDatabaseEnabled()).add("MasterUserOptions", (Object)this.masterUserOptions()).add("SAMLOptions", (Object)this.samlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "InternalUserDatabaseEnabled": {
                return Optional.ofNullable(clazz.cast(this.internalUserDatabaseEnabled()));
            }
            case "MasterUserOptions": {
                return Optional.ofNullable(clazz.cast(this.masterUserOptions()));
            }
            case "SAMLOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptionsInput, T> g) {
        return obj -> g.apply((AdvancedSecurityOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean internalUserDatabaseEnabled;
        private MasterUserOptions masterUserOptions;
        private SAMLOptionsInput samlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptionsInput model) {
            this.enabled(model.enabled);
            this.internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            this.masterUserOptions(model.masterUserOptions);
            this.samlOptions(model.samlOptions);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return this.internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        public final MasterUserOptions.Builder getMasterUserOptions() {
            return this.masterUserOptions != null ? this.masterUserOptions.toBuilder() : null;
        }

        @Override
        public final Builder masterUserOptions(MasterUserOptions masterUserOptions) {
            this.masterUserOptions = masterUserOptions;
            return this;
        }

        public final void setMasterUserOptions(MasterUserOptions.BuilderImpl masterUserOptions) {
            this.masterUserOptions = masterUserOptions != null ? masterUserOptions.build() : null;
        }

        public final SAMLOptionsInput.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsInput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final void setSamlOptions(SAMLOptionsInput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        public AdvancedSecurityOptionsInput build() {
            return new AdvancedSecurityOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedSecurityOptionsInput> {
        public Builder enabled(Boolean var1);

        public Builder internalUserDatabaseEnabled(Boolean var1);

        public Builder masterUserOptions(MasterUserOptions var1);

        default public Builder masterUserOptions(Consumer<MasterUserOptions.Builder> masterUserOptions) {
            return this.masterUserOptions((MasterUserOptions)((MasterUserOptions.Builder)MasterUserOptions.builder().applyMutation(masterUserOptions)).build());
        }

        public Builder samlOptions(SAMLOptionsInput var1);

        default public Builder samlOptions(Consumer<SAMLOptionsInput.Builder> samlOptions) {
            return this.samlOptions((SAMLOptionsInput)((SAMLOptionsInput.Builder)SAMLOptionsInput.builder().applyMutation(samlOptions)).build());
        }
    }
}

