/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.RecurringCharge;
import software.amazon.awssdk.services.elasticsearch.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedElasticsearchInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedElasticsearchInstance> {
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::reservationName)).setter(ReservedElasticsearchInstance.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()}).build();
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedElasticsearchInstanceId").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::reservedElasticsearchInstanceId)).setter(ReservedElasticsearchInstance.setter(Builder::reservedElasticsearchInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceId").build()}).build();
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedElasticsearchInstanceOfferingId").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::reservedElasticsearchInstanceOfferingId)).setter(ReservedElasticsearchInstance.setter(Builder::reservedElasticsearchInstanceOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceOfferingId").build()}).build();
    private static final SdkField<String> ELASTICSEARCH_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticsearchInstanceType").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::elasticsearchInstanceTypeAsString)).setter(ReservedElasticsearchInstance.setter(Builder::elasticsearchInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::startTime)).setter(ReservedElasticsearchInstance.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::duration)).setter(ReservedElasticsearchInstance.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::fixedPrice)).setter(ReservedElasticsearchInstance.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::usagePrice)).setter(ReservedElasticsearchInstance.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::currencyCode)).setter(ReservedElasticsearchInstance.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> ELASTICSEARCH_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ElasticsearchInstanceCount").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::elasticsearchInstanceCount)).setter(ReservedElasticsearchInstance.setter(Builder::elasticsearchInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::state)).setter(ReservedElasticsearchInstance.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::paymentOptionAsString)).setter(ReservedElasticsearchInstance.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedElasticsearchInstance.getter(ReservedElasticsearchInstance::recurringCharges)).setter(ReservedElasticsearchInstance.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_NAME_FIELD, RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD, RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD, ELASTICSEARCH_INSTANCE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, ELASTICSEARCH_INSTANCE_COUNT_FIELD, STATE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservationName;
    private final String reservedElasticsearchInstanceId;
    private final String reservedElasticsearchInstanceOfferingId;
    private final String elasticsearchInstanceType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer elasticsearchInstanceCount;
    private final String state;
    private final String paymentOption;
    private final List<RecurringCharge> recurringCharges;

    private ReservedElasticsearchInstance(BuilderImpl builder) {
        this.reservationName = builder.reservationName;
        this.reservedElasticsearchInstanceId = builder.reservedElasticsearchInstanceId;
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.elasticsearchInstanceType = builder.elasticsearchInstanceType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.elasticsearchInstanceCount = builder.elasticsearchInstanceCount;
        this.state = builder.state;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final String reservedElasticsearchInstanceId() {
        return this.reservedElasticsearchInstanceId;
    }

    public final String reservedElasticsearchInstanceOfferingId() {
        return this.reservedElasticsearchInstanceOfferingId;
    }

    public final ESPartitionInstanceType elasticsearchInstanceType() {
        return ESPartitionInstanceType.fromValue(this.elasticsearchInstanceType);
    }

    public final String elasticsearchInstanceTypeAsString() {
        return this.elasticsearchInstanceType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer elasticsearchInstanceCount() {
        return this.elasticsearchInstanceCount;
    }

    public final String state() {
        return this.state;
    }

    public final ReservedElasticsearchInstancePaymentOption paymentOption() {
        return ReservedElasticsearchInstancePaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedElasticsearchInstance)) {
            return false;
        }
        ReservedElasticsearchInstance other = (ReservedElasticsearchInstance)obj;
        return Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.reservedElasticsearchInstanceId(), other.reservedElasticsearchInstanceId()) && Objects.equals(this.reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId()) && Objects.equals(this.elasticsearchInstanceTypeAsString(), other.elasticsearchInstanceTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.elasticsearchInstanceCount(), other.elasticsearchInstanceCount()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedElasticsearchInstance").add("ReservationName", (Object)this.reservationName()).add("ReservedElasticsearchInstanceId", (Object)this.reservedElasticsearchInstanceId()).add("ReservedElasticsearchInstanceOfferingId", (Object)this.reservedElasticsearchInstanceOfferingId()).add("ElasticsearchInstanceType", (Object)this.elasticsearchInstanceTypeAsString()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("ElasticsearchInstanceCount", (Object)this.elasticsearchInstanceCount()).add("State", (Object)this.state()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "ReservedElasticsearchInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceId()));
            }
            case "ReservedElasticsearchInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferingId()));
            }
            case "ElasticsearchInstanceType": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchInstanceTypeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "ElasticsearchInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchInstanceCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedElasticsearchInstance, T> g) {
        return obj -> g.apply((ReservedElasticsearchInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservationName;
        private String reservedElasticsearchInstanceId;
        private String reservedElasticsearchInstanceOfferingId;
        private String elasticsearchInstanceType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer elasticsearchInstanceCount;
        private String state;
        private String paymentOption;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedElasticsearchInstance model) {
            this.reservationName(model.reservationName);
            this.reservedElasticsearchInstanceId(model.reservedElasticsearchInstanceId);
            this.reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            this.elasticsearchInstanceType(model.elasticsearchInstanceType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.elasticsearchInstanceCount(model.elasticsearchInstanceCount);
            this.state(model.state);
            this.paymentOption(model.paymentOption);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        public final String getReservedElasticsearchInstanceId() {
            return this.reservedElasticsearchInstanceId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
            return this;
        }

        public final void setReservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return this.reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        public final String getElasticsearchInstanceType() {
            return this.elasticsearchInstanceType;
        }

        @Override
        public final Builder elasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
            return this;
        }

        @Override
        public final Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType) {
            this.elasticsearchInstanceType(elasticsearchInstanceType == null ? null : elasticsearchInstanceType.toString());
            return this;
        }

        public final void setElasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getElasticsearchInstanceCount() {
            return this.elasticsearchInstanceCount;
        }

        @Override
        public final Builder elasticsearchInstanceCount(Integer elasticsearchInstanceCount) {
            this.elasticsearchInstanceCount = elasticsearchInstanceCount;
            return this;
        }

        public final void setElasticsearchInstanceCount(Integer elasticsearchInstanceCount) {
            this.elasticsearchInstanceCount = elasticsearchInstanceCount;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            if (this.recurringCharges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public ReservedElasticsearchInstance build() {
            return new ReservedElasticsearchInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedElasticsearchInstance> {
        public Builder reservationName(String var1);

        public Builder reservedElasticsearchInstanceId(String var1);

        public Builder reservedElasticsearchInstanceOfferingId(String var1);

        public Builder elasticsearchInstanceType(String var1);

        public Builder elasticsearchInstanceType(ESPartitionInstanceType var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder elasticsearchInstanceCount(Integer var1);

        public Builder state(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(ReservedElasticsearchInstancePaymentOption var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

