/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection;
import software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInboundCrossClusterSearchConnectionsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeInboundCrossClusterSearchConnectionsResponse> {
    private static final SdkField<List<InboundCrossClusterSearchConnection>> CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossClusterSearchConnections").getter(DescribeInboundCrossClusterSearchConnectionsResponse.getter(DescribeInboundCrossClusterSearchConnectionsResponse::crossClusterSearchConnections)).setter(DescribeInboundCrossClusterSearchConnectionsResponse.setter(Builder::crossClusterSearchConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InboundCrossClusterSearchConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInboundCrossClusterSearchConnectionsResponse.getter(DescribeInboundCrossClusterSearchConnectionsResponse::nextToken)).setter(DescribeInboundCrossClusterSearchConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InboundCrossClusterSearchConnection> crossClusterSearchConnections;
    private final String nextToken;

    private DescribeInboundCrossClusterSearchConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnections = builder.crossClusterSearchConnections;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCrossClusterSearchConnections() {
        return this.crossClusterSearchConnections != null && !(this.crossClusterSearchConnections instanceof SdkAutoConstructList);
    }

    public final List<InboundCrossClusterSearchConnection> crossClusterSearchConnections() {
        return this.crossClusterSearchConnections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossClusterSearchConnections() ? this.crossClusterSearchConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundCrossClusterSearchConnectionsResponse)) {
            return false;
        }
        DescribeInboundCrossClusterSearchConnectionsResponse other = (DescribeInboundCrossClusterSearchConnectionsResponse)((Object)obj);
        return this.hasCrossClusterSearchConnections() == other.hasCrossClusterSearchConnections() && Objects.equals(this.crossClusterSearchConnections(), other.crossClusterSearchConnections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInboundCrossClusterSearchConnectionsResponse").add("CrossClusterSearchConnections", this.hasCrossClusterSearchConnections() ? this.crossClusterSearchConnections() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrossClusterSearchConnections": {
                return Optional.ofNullable(clazz.cast(this.crossClusterSearchConnections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundCrossClusterSearchConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeInboundCrossClusterSearchConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<InboundCrossClusterSearchConnection> crossClusterSearchConnections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundCrossClusterSearchConnectionsResponse model) {
            super(model);
            this.crossClusterSearchConnections(model.crossClusterSearchConnections);
            this.nextToken(model.nextToken);
        }

        public final Collection<InboundCrossClusterSearchConnection.Builder> getCrossClusterSearchConnections() {
            if (this.crossClusterSearchConnections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crossClusterSearchConnections != null ? (Collection)this.crossClusterSearchConnections.stream().map(InboundCrossClusterSearchConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crossClusterSearchConnections(Collection<InboundCrossClusterSearchConnection> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = InboundCrossClusterSearchConnectionsCopier.copy(crossClusterSearchConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(InboundCrossClusterSearchConnection ... crossClusterSearchConnections) {
            this.crossClusterSearchConnections(Arrays.asList(crossClusterSearchConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(Consumer<InboundCrossClusterSearchConnection.Builder> ... crossClusterSearchConnections) {
            this.crossClusterSearchConnections(Stream.of(crossClusterSearchConnections).map(c -> (InboundCrossClusterSearchConnection)((InboundCrossClusterSearchConnection.Builder)InboundCrossClusterSearchConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrossClusterSearchConnections(Collection<InboundCrossClusterSearchConnection.BuilderImpl> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = InboundCrossClusterSearchConnectionsCopier.copyFromBuilder(crossClusterSearchConnections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInboundCrossClusterSearchConnectionsResponse build() {
            return new DescribeInboundCrossClusterSearchConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInboundCrossClusterSearchConnectionsResponse> {
        public Builder crossClusterSearchConnections(Collection<InboundCrossClusterSearchConnection> var1);

        public Builder crossClusterSearchConnections(InboundCrossClusterSearchConnection ... var1);

        public Builder crossClusterSearchConnections(Consumer<InboundCrossClusterSearchConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

