/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatusListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchDomainsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
    private static final SdkField<List<ElasticsearchDomainStatus>> DOMAIN_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainStatusList").getter(DescribeElasticsearchDomainsResponse.getter(DescribeElasticsearchDomainsResponse::domainStatusList)).setter(DescribeElasticsearchDomainsResponse.setter(Builder::domainStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticsearchDomainStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_LIST_FIELD));
    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    public final boolean hasDomainStatusList() {
        return this.domainStatusList != null && !(this.domainStatusList instanceof SdkAutoConstructList);
    }

    public final List<ElasticsearchDomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainStatusList() ? this.domainStatusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse)((Object)obj);
        return this.hasDomainStatusList() == other.hasDomainStatusList() && Objects.equals(this.domainStatusList(), other.domainStatusList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeElasticsearchDomainsResponse").add("DomainStatusList", this.hasDomainStatusList() ? this.domainStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.ofNullable(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchDomainsResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            super(model);
            this.domainStatusList(model.domainStatusList);
        }

        public final Collection<ElasticsearchDomainStatus.Builder> getDomainStatusList() {
            if (this.domainStatusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainStatusList != null ? (Collection)this.domainStatusList.stream().map(ElasticsearchDomainStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder> ... domainStatusList) {
            this.domainStatusList(Stream.of(domainStatusList).map(c -> (ElasticsearchDomainStatus)((ElasticsearchDomainStatus.Builder)ElasticsearchDomainStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        public Builder domainStatusList(Collection<ElasticsearchDomainStatus> var1);

        public Builder domainStatusList(ElasticsearchDomainStatus ... var1);

        public Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder> ... var1);
    }
}

