/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.PackageDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackageResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, CreatePackageResponse> {
    private static final SdkField<PackageDetails> PACKAGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageDetails").getter(CreatePackageResponse.getter(CreatePackageResponse::packageDetails)).setter(CreatePackageResponse.setter(Builder::packageDetails)).constructor(PackageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_DETAILS_FIELD));
    private final PackageDetails packageDetails;

    private CreatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageDetails = builder.packageDetails;
    }

    public final PackageDetails packageDetails() {
        return this.packageDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageResponse)) {
            return false;
        }
        CreatePackageResponse other = (CreatePackageResponse)((Object)obj);
        return Objects.equals(this.packageDetails(), other.packageDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackageResponse").add("PackageDetails", (Object)this.packageDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageDetails": {
                return Optional.ofNullable(clazz.cast(this.packageDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageResponse, T> g) {
        return obj -> g.apply((CreatePackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private PackageDetails packageDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageResponse model) {
            super(model);
            this.packageDetails(model.packageDetails);
        }

        public final PackageDetails.Builder getPackageDetails() {
            return this.packageDetails != null ? this.packageDetails.toBuilder() : null;
        }

        @Override
        public final Builder packageDetails(PackageDetails packageDetails) {
            this.packageDetails = packageDetails;
            return this;
        }

        public final void setPackageDetails(PackageDetails.BuilderImpl packageDetails) {
            this.packageDetails = packageDetails != null ? packageDetails.build() : null;
        }

        @Override
        public CreatePackageResponse build() {
            return new CreatePackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackageResponse> {
        public Builder packageDetails(PackageDetails var1);

        default public Builder packageDetails(Consumer<PackageDetails.Builder> packageDetails) {
            return this.packageDetails((PackageDetails)((PackageDetails.Builder)PackageDetails.builder().applyMutation(packageDetails)).build());
        }
    }
}

