/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchInstanceTypeLimitsRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeElasticsearchInstanceTypeLimitsRequest.getter(DescribeElasticsearchInstanceTypeLimitsRequest::domainName)).setter(DescribeElasticsearchInstanceTypeLimitsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DescribeElasticsearchInstanceTypeLimitsRequest.getter(DescribeElasticsearchInstanceTypeLimitsRequest::instanceTypeAsString)).setter(DescribeElasticsearchInstanceTypeLimitsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceType").build()}).build();
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticsearchVersion").getter(DescribeElasticsearchInstanceTypeLimitsRequest.getter(DescribeElasticsearchInstanceTypeLimitsRequest::elasticsearchVersion)).setter(DescribeElasticsearchInstanceTypeLimitsRequest.setter(Builder::elasticsearchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ElasticsearchVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, INSTANCE_TYPE_FIELD, ELASTICSEARCH_VERSION_FIELD));
    private final String domainName;
    private final String instanceType;
    private final String elasticsearchVersion;

    private DescribeElasticsearchInstanceTypeLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.instanceType = builder.instanceType;
        this.elasticsearchVersion = builder.elasticsearchVersion;
    }

    public String domainName() {
        return this.domainName;
    }

    public ESPartitionInstanceType instanceType() {
        return ESPartitionInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsRequest)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsRequest other = (DescribeElasticsearchInstanceTypeLimitsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticsearchInstanceTypeLimitsRequest").add("DomainName", (Object)this.domainName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchInstanceTypeLimitsRequest, T> g) {
        return obj -> g.apply((DescribeElasticsearchInstanceTypeLimitsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String instanceType;
        private String elasticsearchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.instanceType(model.instanceType);
            this.elasticsearchVersion(model.elasticsearchVersion);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticsearchInstanceTypeLimitsRequest build() {
            return new DescribeElasticsearchInstanceTypeLimitsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
        public Builder domainName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder elasticsearchVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

