/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;

public class ListElasticsearchInstanceTypesPublisher
implements SdkPublisher<ListElasticsearchInstanceTypesResponse> {
    private final ElasticsearchAsyncClient client;
    private final ListElasticsearchInstanceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListElasticsearchInstanceTypesPublisher(ElasticsearchAsyncClient client, ListElasticsearchInstanceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListElasticsearchInstanceTypesPublisher(ElasticsearchAsyncClient client, ListElasticsearchInstanceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListElasticsearchInstanceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListElasticsearchInstanceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListElasticsearchInstanceTypesResponseFetcher
    implements AsyncPageFetcher<ListElasticsearchInstanceTypesResponse> {
        private ListElasticsearchInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListElasticsearchInstanceTypesResponse> nextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchInstanceTypesPublisher.this.client.listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesPublisher.this.firstRequest);
            }
            return ListElasticsearchInstanceTypesPublisher.this.client.listElasticsearchInstanceTypes((ListElasticsearchInstanceTypesRequest)((Object)ListElasticsearchInstanceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

