/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.DomainInformation;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOutboundCrossClusterSearchConnectionResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, CreateOutboundCrossClusterSearchConnectionResponse> {
    private static final SdkField<DomainInformation> SOURCE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateOutboundCrossClusterSearchConnectionResponse.getter(CreateOutboundCrossClusterSearchConnectionResponse::sourceDomainInfo)).setter(CreateOutboundCrossClusterSearchConnectionResponse.setter(Builder::sourceDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomainInfo").build()}).build();
    private static final SdkField<DomainInformation> DESTINATION_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateOutboundCrossClusterSearchConnectionResponse.getter(CreateOutboundCrossClusterSearchConnectionResponse::destinationDomainInfo)).setter(CreateOutboundCrossClusterSearchConnectionResponse.setter(Builder::destinationDomainInfo)).constructor(DomainInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomainInfo").build()}).build();
    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOutboundCrossClusterSearchConnectionResponse.getter(CreateOutboundCrossClusterSearchConnectionResponse::connectionAlias)).setter(CreateOutboundCrossClusterSearchConnectionResponse.setter(Builder::connectionAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()}).build();
    private static final SdkField<OutboundCrossClusterSearchConnectionStatus> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateOutboundCrossClusterSearchConnectionResponse.getter(CreateOutboundCrossClusterSearchConnectionResponse::connectionStatus)).setter(CreateOutboundCrossClusterSearchConnectionResponse.setter(Builder::connectionStatus)).constructor(OutboundCrossClusterSearchConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<String> CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateOutboundCrossClusterSearchConnectionResponse.getter(CreateOutboundCrossClusterSearchConnectionResponse::crossClusterSearchConnectionId)).setter(CreateOutboundCrossClusterSearchConnectionResponse.setter(Builder::crossClusterSearchConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DOMAIN_INFO_FIELD, DESTINATION_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD, CONNECTION_STATUS_FIELD, CROSS_CLUSTER_SEARCH_CONNECTION_ID_FIELD));
    private final DomainInformation sourceDomainInfo;
    private final DomainInformation destinationDomainInfo;
    private final String connectionAlias;
    private final OutboundCrossClusterSearchConnectionStatus connectionStatus;
    private final String crossClusterSearchConnectionId;

    private CreateOutboundCrossClusterSearchConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.sourceDomainInfo = builder.sourceDomainInfo;
        this.destinationDomainInfo = builder.destinationDomainInfo;
        this.connectionAlias = builder.connectionAlias;
        this.connectionStatus = builder.connectionStatus;
        this.crossClusterSearchConnectionId = builder.crossClusterSearchConnectionId;
    }

    public DomainInformation sourceDomainInfo() {
        return this.sourceDomainInfo;
    }

    public DomainInformation destinationDomainInfo() {
        return this.destinationDomainInfo;
    }

    public String connectionAlias() {
        return this.connectionAlias;
    }

    public OutboundCrossClusterSearchConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public String crossClusterSearchConnectionId() {
        return this.crossClusterSearchConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossClusterSearchConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundCrossClusterSearchConnectionResponse)) {
            return false;
        }
        CreateOutboundCrossClusterSearchConnectionResponse other = (CreateOutboundCrossClusterSearchConnectionResponse)((Object)obj);
        return Objects.equals(this.sourceDomainInfo(), other.sourceDomainInfo()) && Objects.equals(this.destinationDomainInfo(), other.destinationDomainInfo()) && Objects.equals(this.connectionAlias(), other.connectionAlias()) && Objects.equals(this.connectionStatus(), other.connectionStatus()) && Objects.equals(this.crossClusterSearchConnectionId(), other.crossClusterSearchConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateOutboundCrossClusterSearchConnectionResponse").add("SourceDomainInfo", (Object)this.sourceDomainInfo()).add("DestinationDomainInfo", (Object)this.destinationDomainInfo()).add("ConnectionAlias", (Object)this.connectionAlias()).add("ConnectionStatus", (Object)this.connectionStatus()).add("CrossClusterSearchConnectionId", (Object)this.crossClusterSearchConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceDomainInfo()));
            }
            case "DestinationDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.destinationDomainInfo()));
            }
            case "ConnectionAlias": {
                return Optional.ofNullable(clazz.cast(this.connectionAlias()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
            case "CrossClusterSearchConnectionId": {
                return Optional.ofNullable(clazz.cast(this.crossClusterSearchConnectionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundCrossClusterSearchConnectionResponse, T> g) {
        return obj -> g.apply((CreateOutboundCrossClusterSearchConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private DomainInformation sourceDomainInfo;
        private DomainInformation destinationDomainInfo;
        private String connectionAlias;
        private OutboundCrossClusterSearchConnectionStatus connectionStatus;
        private String crossClusterSearchConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundCrossClusterSearchConnectionResponse model) {
            super(model);
            this.sourceDomainInfo(model.sourceDomainInfo);
            this.destinationDomainInfo(model.destinationDomainInfo);
            this.connectionAlias(model.connectionAlias);
            this.connectionStatus(model.connectionStatus);
            this.crossClusterSearchConnectionId(model.crossClusterSearchConnectionId);
        }

        public final DomainInformation.Builder getSourceDomainInfo() {
            return this.sourceDomainInfo != null ? this.sourceDomainInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceDomainInfo(DomainInformation sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo;
            return this;
        }

        public final void setSourceDomainInfo(DomainInformation.BuilderImpl sourceDomainInfo) {
            this.sourceDomainInfo = sourceDomainInfo != null ? sourceDomainInfo.build() : null;
        }

        public final DomainInformation.Builder getDestinationDomainInfo() {
            return this.destinationDomainInfo != null ? this.destinationDomainInfo.toBuilder() : null;
        }

        @Override
        public final Builder destinationDomainInfo(DomainInformation destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo;
            return this;
        }

        public final void setDestinationDomainInfo(DomainInformation.BuilderImpl destinationDomainInfo) {
            this.destinationDomainInfo = destinationDomainInfo != null ? destinationDomainInfo.build() : null;
        }

        public final String getConnectionAlias() {
            return this.connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        public final OutboundCrossClusterSearchConnectionStatus.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        @Override
        public final Builder connectionStatus(OutboundCrossClusterSearchConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final void setConnectionStatus(OutboundCrossClusterSearchConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        public final String getCrossClusterSearchConnectionId() {
            return this.crossClusterSearchConnectionId;
        }

        @Override
        public final Builder crossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
            return this;
        }

        public final void setCrossClusterSearchConnectionId(String crossClusterSearchConnectionId) {
            this.crossClusterSearchConnectionId = crossClusterSearchConnectionId;
        }

        @Override
        public CreateOutboundCrossClusterSearchConnectionResponse build() {
            return new CreateOutboundCrossClusterSearchConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOutboundCrossClusterSearchConnectionResponse> {
        public Builder sourceDomainInfo(DomainInformation var1);

        default public Builder sourceDomainInfo(Consumer<DomainInformation.Builder> sourceDomainInfo) {
            return this.sourceDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(sourceDomainInfo)).build());
        }

        public Builder destinationDomainInfo(DomainInformation var1);

        default public Builder destinationDomainInfo(Consumer<DomainInformation.Builder> destinationDomainInfo) {
            return this.destinationDomainInfo((DomainInformation)((DomainInformation.Builder)DomainInformation.builder().applyMutation(destinationDomainInfo)).build());
        }

        public Builder connectionAlias(String var1);

        public Builder connectionStatus(OutboundCrossClusterSearchConnectionStatus var1);

        default public Builder connectionStatus(Consumer<OutboundCrossClusterSearchConnectionStatus.Builder> connectionStatus) {
            return this.connectionStatus((OutboundCrossClusterSearchConnectionStatus)((OutboundCrossClusterSearchConnectionStatus.Builder)OutboundCrossClusterSearchConnectionStatus.builder().applyMutation(connectionStatus)).build());
        }

        public Builder crossClusterSearchConnectionId(String var1);
    }
}

