/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentStatus {
    PENDING_UPDATE("PENDING_UPDATE"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    NOT_ELIGIBLE("NOT_ELIGIBLE"),
    ELIGIBLE("ELIGIBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentStatus> knownValues() {
        return Stream.of(DeploymentStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

