/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> request. Contains the list of
 * connections matching the filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOutboundCrossClusterSearchConnectionsResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<DescribeOutboundCrossClusterSearchConnectionsResponse.Builder, DescribeOutboundCrossClusterSearchConnectionsResponse> {
    private static final SdkField<List<OutboundCrossClusterSearchConnection>> CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD = SdkField
            .<List<OutboundCrossClusterSearchConnection>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOutboundCrossClusterSearchConnectionsResponse::crossClusterSearchConnections))
            .setter(setter(Builder::crossClusterSearchConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnections")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutboundCrossClusterSearchConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutboundCrossClusterSearchConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOutboundCrossClusterSearchConnectionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CROSS_CLUSTER_SEARCH_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<OutboundCrossClusterSearchConnection> crossClusterSearchConnections;

    private final String nextToken;

    private DescribeOutboundCrossClusterSearchConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnections = builder.crossClusterSearchConnections;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CrossClusterSearchConnections property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCrossClusterSearchConnections() {
        return crossClusterSearchConnections != null && !(crossClusterSearchConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrossClusterSearchConnections()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified
     *         filter criteria.
     */
    public List<OutboundCrossClusterSearchConnection> crossClusterSearchConnections() {
        return crossClusterSearchConnections;
    }

    /**
     * <p>
     * If more results are available and NextToken is present, make the next request to the same API with the received
     * NextToken to paginate the remaining results.
     * </p>
     * 
     * @return If more results are available and NextToken is present, make the next request to the same API with the
     *         received NextToken to paginate the remaining results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearchConnections());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOutboundCrossClusterSearchConnectionsResponse)) {
            return false;
        }
        DescribeOutboundCrossClusterSearchConnectionsResponse other = (DescribeOutboundCrossClusterSearchConnectionsResponse) obj;
        return Objects.equals(crossClusterSearchConnections(), other.crossClusterSearchConnections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOutboundCrossClusterSearchConnectionsResponse")
                .add("CrossClusterSearchConnections", crossClusterSearchConnections()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossClusterSearchConnections":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOutboundCrossClusterSearchConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeOutboundCrossClusterSearchConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOutboundCrossClusterSearchConnectionsResponse> {
        /**
         * <p>
         * Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * 
         * @param crossClusterSearchConnections
         *        Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified
         *        filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnections(Collection<OutboundCrossClusterSearchConnection> crossClusterSearchConnections);

        /**
         * <p>
         * Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * 
         * @param crossClusterSearchConnections
         *        Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified
         *        filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnections(OutboundCrossClusterSearchConnection... crossClusterSearchConnections);

        /**
         * <p>
         * Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter
         * criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <OutboundCrossClusterSearchConnection>.Builder} avoiding the need to create one manually via {@link List
         * <OutboundCrossClusterSearchConnection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutboundCrossClusterSearchConnection>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #crossClusterSearchConnections(List<OutboundCrossClusterSearchConnection>)}.
         * 
         * @param crossClusterSearchConnections
         *        a consumer that will call methods on {@link List<OutboundCrossClusterSearchConnection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossClusterSearchConnections(List<OutboundCrossClusterSearchConnection>)
         */
        Builder crossClusterSearchConnections(
                Consumer<OutboundCrossClusterSearchConnection.Builder>... crossClusterSearchConnections);

        /**
         * <p>
         * If more results are available and NextToken is present, make the next request to the same API with the
         * received NextToken to paginate the remaining results.
         * </p>
         * 
         * @param nextToken
         *        If more results are available and NextToken is present, make the next request to the same API with the
         *        received NextToken to paginate the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<OutboundCrossClusterSearchConnection> crossClusterSearchConnections = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOutboundCrossClusterSearchConnectionsResponse model) {
            super(model);
            crossClusterSearchConnections(model.crossClusterSearchConnections);
            nextToken(model.nextToken);
        }

        public final Collection<OutboundCrossClusterSearchConnection.Builder> getCrossClusterSearchConnections() {
            return crossClusterSearchConnections != null ? crossClusterSearchConnections.stream()
                    .map(OutboundCrossClusterSearchConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crossClusterSearchConnections(
                Collection<OutboundCrossClusterSearchConnection> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = OutboundCrossClusterSearchConnectionsCopier.copy(crossClusterSearchConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(OutboundCrossClusterSearchConnection... crossClusterSearchConnections) {
            crossClusterSearchConnections(Arrays.asList(crossClusterSearchConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossClusterSearchConnections(
                Consumer<OutboundCrossClusterSearchConnection.Builder>... crossClusterSearchConnections) {
            crossClusterSearchConnections(Stream.of(crossClusterSearchConnections)
                    .map(c -> OutboundCrossClusterSearchConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCrossClusterSearchConnections(
                Collection<OutboundCrossClusterSearchConnection.BuilderImpl> crossClusterSearchConnections) {
            this.crossClusterSearchConnections = OutboundCrossClusterSearchConnectionsCopier
                    .copyFromBuilder(crossClusterSearchConnections);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOutboundCrossClusterSearchConnectionsResponse build() {
            return new DescribeOutboundCrossClusterSearchConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
