/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of limits that are specific to a given InstanceType and for each of it's <code> <a>InstanceRole</a> </code> .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalLimit implements SdkPojo, Serializable, ToCopyableBuilder<AdditionalLimit.Builder, AdditionalLimit> {
    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdditionalLimit::limitName)).setter(setter(Builder::limitName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()).build();

    private static final SdkField<List<String>> LIMIT_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AdditionalLimit::limitValues))
            .setter(setter(Builder::limitValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_NAME_FIELD,
            LIMIT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String limitName;

    private final List<String> limitValues;

    private AdditionalLimit(BuilderImpl builder) {
        this.limitName = builder.limitName;
        this.limitValues = builder.limitValues;
    }

    /**
     * <p>
     * Name of Additional Limit is specific to a given InstanceType and for each of it's
     * <code> <a>InstanceRole</a> </code> etc. <br/>
     * Attributes and their details: <br/>
     * <ul>
     * <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much
     * data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support as master node.
     * <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify
     * how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you don't need any master
     * nodes to govern them.
     * </ul>
     * </p>
     * 
     * @return Name of Additional Limit is specific to a given InstanceType and for each of it's
     *         <code> <a>InstanceRole</a> </code> etc. <br/>
     *         Attributes and their details: <br/>
     *         <ul>
     *         <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify
     *         how much data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support as master
     *         node.
     *         <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to
     *         specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you don't
     *         need any master nodes to govern them.
     *         </ul>
     */
    public String limitName() {
        return limitName;
    }

    /**
     * Returns true if the LimitValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLimitValues() {
        return limitValues != null && !(limitValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLimitValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
     */
    public List<String> limitValues() {
        return limitValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limitName());
        hashCode = 31 * hashCode + Objects.hashCode(limitValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalLimit)) {
            return false;
        }
        AdditionalLimit other = (AdditionalLimit) obj;
        return Objects.equals(limitName(), other.limitName()) && Objects.equals(limitValues(), other.limitValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdditionalLimit").add("LimitName", limitName()).add("LimitValues", limitValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LimitName":
            return Optional.ofNullable(clazz.cast(limitName()));
        case "LimitValues":
            return Optional.ofNullable(clazz.cast(limitValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalLimit, T> g) {
        return obj -> g.apply((AdditionalLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalLimit> {
        /**
         * <p>
         * Name of Additional Limit is specific to a given InstanceType and for each of it's
         * <code> <a>InstanceRole</a> </code> etc. <br/>
         * Attributes and their details: <br/>
         * <ul>
         * <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how
         * much data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support as master node.
         * <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to
         * specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you don't need
         * any master nodes to govern them.
         * </ul>
         * </p>
         * 
         * @param limitName
         *        Name of Additional Limit is specific to a given InstanceType and for each of it's
         *        <code> <a>InstanceRole</a> </code> etc. <br/>
         *        Attributes and their details: <br/>
         *        <ul>
         *        <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to
         *        specify how much data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support
         *        as master node.
         *        <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to
         *        specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you
         *        don't need any master nodes to govern them.
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitName(String limitName);

        /**
         * <p>
         * Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
         * </p>
         * 
         * @param limitValues
         *        Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitValues(Collection<String> limitValues);

        /**
         * <p>
         * Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
         * </p>
         * 
         * @param limitValues
         *        Value for given <code> <a>AdditionalLimit$LimitName</a> </code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitValues(String... limitValues);
    }

    static final class BuilderImpl implements Builder {
        private String limitName;

        private List<String> limitValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalLimit model) {
            limitName(model.limitName);
            limitValues(model.limitValues);
        }

        public final String getLimitName() {
            return limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        public final Collection<String> getLimitValues() {
            return limitValues;
        }

        @Override
        public final Builder limitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitValues(String... limitValues) {
            limitValues(Arrays.asList(limitValues));
            return this;
        }

        public final void setLimitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
        }

        @Override
        public AdditionalLimit build() {
            return new AdditionalLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
