/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher;

/**
 * Service client for accessing Amazon Elasticsearch Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon Elasticsearch Configuration Service</fullname>
 * <p>
 * Use the Amazon Elasticsearch Configuration API to create, configure, and manage Elasticsearch domains.
 * </p>
 * <p>
 * For sample code that uses the Configuration API, see the <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-samples.html">Amazon
 * Elasticsearch Service Developer Guide</a>. The guide also contains <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-request-signing.html">sample code
 * for sending signed HTTP requests to the Elasticsearch APIs</a>.
 * </p>
 * <p>
 * The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example,
 * es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions" target="_blank">Regions
 * and Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ElasticsearchAsyncClient extends SdkClient {
    String SERVICE_NAME = "es";

    /**
     * Create a {@link ElasticsearchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticsearchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticsearchAsyncClient}.
     */
    static ElasticsearchAsyncClientBuilder builder() {
        return new DefaultElasticsearchAsyncClientBuilder();
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want
     *        to attach to the Elasticsearch domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsRequest.Builder} to create a request. Container
     *        for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want to attach
     *        to the Elasticsearch domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code>
     *        operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software
     *        update on.
     * @return A Java Future containing the result of the CancelElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CancelElasticsearchServiceSoftwareUpdate
     */
    default CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> cancelElasticsearchServiceSoftwareUpdate(
            CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelElasticsearchServiceSoftwareUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link CancelElasticsearchServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CancelElasticsearchServiceSoftwareUpdateRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you wish to cancel a service software update on.
     * @return A Java Future containing the result of the CancelElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CancelElasticsearchServiceSoftwareUpdate
     */
    default CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> cancelElasticsearchServiceSoftwareUpdate(
            Consumer<CancelElasticsearchServiceSoftwareUpdateRequest.Builder> cancelElasticsearchServiceSoftwareUpdateRequest) {
        return cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest.builder()
                .applyMutation(cancelElasticsearchServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     *
     * @param createElasticsearchDomainRequest
     * @return A Java Future containing the result of the CreateElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateElasticsearchDomain
     */
    default CompletableFuture<CreateElasticsearchDomainResponse> createElasticsearchDomain(
            CreateElasticsearchDomainRequest createElasticsearchDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link CreateElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param createElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateElasticsearchDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateElasticsearchDomain
     */
    default CompletableFuture<CreateElasticsearchDomainResponse> createElasticsearchDomain(
            Consumer<CreateElasticsearchDomainRequest.Builder> createElasticsearchDomainRequest) {
        return createElasticsearchDomain(CreateElasticsearchDomainRequest.builder()
                .applyMutation(createElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you want to delete.
     * @return A Java Future containing the result of the DeleteElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchDomain
     */
    default CompletableFuture<DeleteElasticsearchDomainResponse> deleteElasticsearchDomain(
            DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteElasticsearchDomainRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you want to delete.
     * @return A Java Future containing the result of the DeleteElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchDomain
     */
    default CompletableFuture<DeleteElasticsearchDomainResponse> deleteElasticsearchDomain(
            Consumer<DeleteElasticsearchDomainRequest.Builder> deleteElasticsearchDomainRequest) {
        return deleteElasticsearchDomain(DeleteElasticsearchDomainRequest.builder()
                .applyMutation(deleteElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     * @return A Java Future containing the result of the DeleteElasticsearchServiceRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchServiceRole
     */
    default CompletableFuture<DeleteElasticsearchServiceRoleResponse> deleteElasticsearchServiceRole(
            DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteElasticsearchServiceRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteElasticsearchServiceRoleRequest#builder()}
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteElasticsearchServiceRoleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteElasticsearchServiceRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchServiceRole
     */
    default CompletableFuture<DeleteElasticsearchServiceRoleResponse> deleteElasticsearchServiceRole(
            Consumer<DeleteElasticsearchServiceRoleRequest.Builder> deleteElasticsearchServiceRoleRequest) {
        return deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.builder()
                .applyMutation(deleteElasticsearchServiceRoleRequest).build());
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteElasticsearchServiceRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchServiceRole
     */
    default CompletableFuture<DeleteElasticsearchServiceRoleResponse> deleteElasticsearchServiceRole() {
        return deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.builder().build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomain
     */
    default CompletableFuture<DescribeElasticsearchDomainResponse> describeElasticsearchDomain(
            DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomain
     */
    default CompletableFuture<DescribeElasticsearchDomainResponse> describeElasticsearchDomain(
            Consumer<DescribeElasticsearchDomainRequest.Builder> describeElasticsearchDomainRequest) {
        return describeElasticsearchDomain(DescribeElasticsearchDomainRequest.builder()
                .applyMutation(describeElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies
     *        the domain name for which you want configuration information.
     * @return A Java Future containing the result of the DescribeElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomainConfig
     */
    default CompletableFuture<DescribeElasticsearchDomainConfigResponse> describeElasticsearchDomainConfig(
            DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainConfigRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainConfigRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code>
     *        operation. Specifies the domain name for which you want configuration information.
     * @return A Java Future containing the result of the DescribeElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomainConfig
     */
    default CompletableFuture<DescribeElasticsearchDomainConfigResponse> describeElasticsearchDomainConfig(
            Consumer<DescribeElasticsearchDomainConfigRequest.Builder> describeElasticsearchDomainConfigRequest) {
        return describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest.builder()
                .applyMutation(describeElasticsearchDomainConfigRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By
     *        default, the API returns the status of all Elasticsearch domains.
     * @return A Java Future containing the result of the DescribeElasticsearchDomains operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomains
     */
    default CompletableFuture<DescribeElasticsearchDomainsResponse> describeElasticsearchDomains(
            DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainsRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainsRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation.
     *        By default, the API returns the status of all Elasticsearch domains.
     * @return A Java Future containing the result of the DescribeElasticsearchDomains operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomains
     */
    default CompletableFuture<DescribeElasticsearchDomainsResponse> describeElasticsearchDomains(
            Consumer<DescribeElasticsearchDomainsRequest.Builder> describeElasticsearchDomainsRequest) {
        return describeElasticsearchDomains(DescribeElasticsearchDomainsRequest.builder()
                .applyMutation(describeElasticsearchDomainsRequest).build());
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchInstanceTypeLimits operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchInstanceTypeLimits
     */
    default CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> describeElasticsearchInstanceTypeLimits(
            DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeElasticsearchInstanceTypeLimitsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeElasticsearchInstanceTypeLimitsRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeElasticsearchInstanceTypeLimitsRequest.Builder} to create a request. Container for the
     *        parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchInstanceTypeLimits operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchInstanceTypeLimits
     */
    default CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> describeElasticsearchInstanceTypeLimits(
            Consumer<DescribeElasticsearchInstanceTypeLimitsRequest.Builder> describeElasticsearchInstanceTypeLimitsRequest) {
        return describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest.builder()
                .applyMutation(describeElasticsearchInstanceTypeLimitsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstanceOfferings operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> describeReservedElasticsearchInstanceOfferings(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeReservedElasticsearchInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} to create a request. Container for
     *        parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstanceOfferings operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> describeReservedElasticsearchInstanceOfferings(
            Consumer<DescribeReservedElasticsearchInstanceOfferingsRequest.Builder> describeReservedElasticsearchInstanceOfferingsRequest) {
        return describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedElasticsearchInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstanceOfferings operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> describeReservedElasticsearchInstanceOfferings() {
        return describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.builder()
                .build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsPublisher describeReservedElasticsearchInstanceOfferingsPaginator() {
        return describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest
                .builder().build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsPublisher describeReservedElasticsearchInstanceOfferingsPaginator(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeReservedElasticsearchInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} to create a request. Container for
     *        parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsPublisher describeReservedElasticsearchInstanceOfferingsPaginator(
            Consumer<DescribeReservedElasticsearchInstanceOfferingsRequest.Builder> describeReservedElasticsearchInstanceOfferingsRequest) {
        return describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest
                .builder().applyMutation(describeReservedElasticsearchInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default CompletableFuture<DescribeReservedElasticsearchInstancesResponse> describeReservedElasticsearchInstances(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedElasticsearchInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedElasticsearchInstancesRequest.Builder}
     *        to create a request. Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default CompletableFuture<DescribeReservedElasticsearchInstancesResponse> describeReservedElasticsearchInstances(
            Consumer<DescribeReservedElasticsearchInstancesRequest.Builder> describeReservedElasticsearchInstancesRequest) {
        return describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.builder()
                .applyMutation(describeReservedElasticsearchInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default CompletableFuture<DescribeReservedElasticsearchInstancesResponse> describeReservedElasticsearchInstances() {
        return describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesPublisher describeReservedElasticsearchInstancesPaginator() {
        return describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesPublisher describeReservedElasticsearchInstancesPaginator(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedElasticsearchInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedElasticsearchInstancesRequest.Builder}
     *        to create a request. Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesPublisher describeReservedElasticsearchInstancesPaginator(
            Consumer<DescribeReservedElasticsearchInstancesRequest.Builder> describeReservedElasticsearchInstancesRequest) {
        return describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest.builder()
                .applyMutation(describeReservedElasticsearchInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        Container for request parameters to <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleElasticsearchVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetCompatibleElasticsearchVersions
     */
    default CompletableFuture<GetCompatibleElasticsearchVersionsResponse> getCompatibleElasticsearchVersions(
            GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleElasticsearchVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCompatibleElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCompatibleElasticsearchVersionsRequest.Builder} to
     *        create a request. Container for request parameters to
     *        <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleElasticsearchVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetCompatibleElasticsearchVersions
     */
    default CompletableFuture<GetCompatibleElasticsearchVersionsResponse> getCompatibleElasticsearchVersions(
            Consumer<GetCompatibleElasticsearchVersionsRequest.Builder> getCompatibleElasticsearchVersionsRequest) {
        return getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.builder()
                .applyMutation(getCompatibleElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @return A Java Future containing the result of the GetCompatibleElasticsearchVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetCompatibleElasticsearchVersions
     */
    default CompletableFuture<GetCompatibleElasticsearchVersionsResponse> getCompatibleElasticsearchVersions() {
        return getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistory(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistoryPaginator(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeStatusRequest#builder()}
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeStatusRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(
            Consumer<GetUpgradeStatusRequest.Builder> getUpgradeStatusRequest) {
        return getUpgradeStatus(GetUpgradeStatusRequest.builder().applyMutation(getUpgradeStatusRequest).build());
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainNamesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(
            Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest) {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames() {
        return listDomainNames(ListDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A Java Future containing the result of the ListElasticsearchInstanceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    default CompletableFuture<ListElasticsearchInstanceTypesResponse> listElasticsearchInstanceTypes(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link ListElasticsearchInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchInstanceTypesRequest.Builder} to
     *        create a request. Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code>
     *        operation.
     * @return A Java Future containing the result of the ListElasticsearchInstanceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    default CompletableFuture<ListElasticsearchInstanceTypesResponse> listElasticsearchInstanceTypes(
            Consumer<ListElasticsearchInstanceTypesRequest.Builder> listElasticsearchInstanceTypesRequest) {
        return listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest.builder()
                .applyMutation(listElasticsearchInstanceTypesRequest).build());
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesPublisher listElasticsearchInstanceTypesPaginator(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link ListElasticsearchInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchInstanceTypesRequest.Builder} to
     *        create a request. Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesPublisher listElasticsearchInstanceTypesPaginator(
            Consumer<ListElasticsearchInstanceTypesRequest.Builder> listElasticsearchInstanceTypesRequest) {
        return listElasticsearchInstanceTypesPaginator(ListElasticsearchInstanceTypesRequest.builder()
                .applyMutation(listElasticsearchInstanceTypesRequest).build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListElasticsearchVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default CompletableFuture<ListElasticsearchVersionsResponse> listElasticsearchVersions(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchVersionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListElasticsearchVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default CompletableFuture<ListElasticsearchVersionsResponse> listElasticsearchVersions(
            Consumer<ListElasticsearchVersionsRequest.Builder> listElasticsearchVersionsRequest) {
        return listElasticsearchVersions(ListElasticsearchVersionsRequest.builder()
                .applyMutation(listElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @return A Java Future containing the result of the ListElasticsearchVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default CompletableFuture<ListElasticsearchVersionsResponse> listElasticsearchVersions() {
        return listElasticsearchVersions(ListElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsPublisher listElasticsearchVersionsPaginator() {
        return listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsPublisher listElasticsearchVersionsPaginator(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchVersionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsPublisher listElasticsearchVersionsPaginator(
            Consumer<ListElasticsearchVersionsRequest.Builder> listElasticsearchVersionsRequest) {
        return listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest.builder()
                .applyMutation(listElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedElasticsearchInstanceOffering operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.PurchaseReservedElasticsearchInstanceOffering
     */
    default CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> purchaseReservedElasticsearchInstanceOffering(
            PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PurchaseReservedElasticsearchInstanceOfferingRequest.Builder} avoiding the need to create one manually via
     * {@link PurchaseReservedElasticsearchInstanceOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PurchaseReservedElasticsearchInstanceOfferingRequest.Builder} to create a request. Container for
     *        parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedElasticsearchInstanceOffering operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.PurchaseReservedElasticsearchInstanceOffering
     */
    default CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> purchaseReservedElasticsearchInstanceOffering(
            Consumer<PurchaseReservedElasticsearchInstanceOfferingRequest.Builder> purchaseReservedElasticsearchInstanceOfferingRequest) {
        return purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest.builder()
                .applyMutation(purchaseReservedElasticsearchInstanceOfferingRequest).build());
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return A Java Future containing the result of the StartElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.StartElasticsearchServiceSoftwareUpdate
     */
    default CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> startElasticsearchServiceSoftwareUpdate(
            StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartElasticsearchServiceSoftwareUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link StartElasticsearchServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartElasticsearchServiceSoftwareUpdateRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return A Java Future containing the result of the StartElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.StartElasticsearchServiceSoftwareUpdate
     */
    default CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> startElasticsearchServiceSoftwareUpdate(
            Consumer<StartElasticsearchServiceSoftwareUpdateRequest.Builder> startElasticsearchServiceSoftwareUpdateRequest) {
        return startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest.builder()
                .applyMutation(startElasticsearchServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the
     *        type and number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdateElasticsearchDomainConfig
     */
    default CompletableFuture<UpdateElasticsearchDomainConfigResponse> updateElasticsearchDomainConfig(
            UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateElasticsearchDomainConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateElasticsearchDomainConfigRequest#builder()}
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateElasticsearchDomainConfigRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code>
     *        operation. Specifies the type and number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdateElasticsearchDomainConfig
     */
    default CompletableFuture<UpdateElasticsearchDomainConfigResponse> updateElasticsearchDomainConfig(
            Consumer<UpdateElasticsearchDomainConfigRequest.Builder> updateElasticsearchDomainConfigRequest) {
        return updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest.builder()
                .applyMutation(updateElasticsearchDomainConfigRequest).build());
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpgradeElasticsearchDomain
     */
    default CompletableFuture<UpgradeElasticsearchDomainResponse> upgradeElasticsearchDomain(
            UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link UpgradeElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpgradeElasticsearchDomainRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpgradeElasticsearchDomain
     */
    default CompletableFuture<UpgradeElasticsearchDomainResponse> upgradeElasticsearchDomain(
            Consumer<UpgradeElasticsearchDomainRequest.Builder> upgradeElasticsearchDomainRequest) {
        return upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest.builder()
                .applyMutation(upgradeElasticsearchDomainRequest).build());
    }
}
