/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;
import software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.services.elasticsearch.model.VPCOptions;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateElasticsearchDomainRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, CreateElasticsearchDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::domainName)).setter(CreateElasticsearchDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::elasticsearchVersion)).setter(CreateElasticsearchDomainRequest.setter(Builder::elasticsearchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<ElasticsearchClusterConfig> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::elasticsearchClusterConfig)).setter(CreateElasticsearchDomainRequest.setter(Builder::elasticsearchClusterConfig)).constructor(ElasticsearchClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::ebsOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::ebsOptions)).constructor(EBSOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::accessPolicies)).setter(CreateElasticsearchDomainRequest.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::snapshotOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::snapshotOptions)).constructor(SnapshotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::vpcOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::vpcOptions)).constructor(VPCOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::cognitoOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::cognitoOptions)).constructor(CognitoOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::encryptionAtRestOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::nodeToNodeEncryptionOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::advancedOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::logPublishingOptionsAsStrings)).setter(CreateElasticsearchDomainRequest.setter(Builder::logPublishingOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateElasticsearchDomainRequest.getter(CreateElasticsearchDomainRequest::domainEndpointOptions)).setter(CreateElasticsearchDomainRequest.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD));
    private final String domainName;
    private final String elasticsearchVersion;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final String accessPolicies;
    private final SnapshotOptions snapshotOptions;
    private final VPCOptions vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final Map<String, String> advancedOptions;
    private final Map<String, LogPublishingOption> logPublishingOptions;
    private final DomainEndpointOptions domainEndpointOptions;

    private CreateElasticsearchDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
    }

    public String domainName() {
        return this.domainName;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.logPublishingOptions);
    }

    public Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    public DomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateElasticsearchDomainRequest)) {
            return false;
        }
        CreateElasticsearchDomainRequest other = (CreateElasticsearchDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions());
    }

    public String toString() {
        return ToString.builder((String)"CreateElasticsearchDomainRequest").add("DomainName", (Object)this.domainName()).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", this.advancedOptions()).add("LogPublishingOptions", this.logPublishingOptionsAsStrings()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateElasticsearchDomainRequest, T> g) {
        return obj -> g.apply((CreateElasticsearchDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String elasticsearchVersion;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private String accessPolicies;
        private SnapshotOptions snapshotOptions;
        private VPCOptions vpcOptions;
        private CognitoOptions cognitoOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();
        private DomainEndpointOptions domainEndpointOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateElasticsearchDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        public final Map<String, String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptionsAsStrings() {
            return this.logPublishingOptions != null ? CollectionUtils.mapValues(this.logPublishingOptions, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final void setLogPublishingOptionsWithStrings(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateElasticsearchDomainRequest build() {
            return new CreateElasticsearchDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateElasticsearchDomainRequest> {
        public Builder domainName(String var1);

        public Builder elasticsearchVersion(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfig.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(String var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCOptions var1);

        default public Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((VPCOptions)((VPCOptions.Builder)VPCOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptions)((NodeToNodeEncryptionOptions.Builder)NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder domainEndpointOptions(DomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptions)((DomainEndpointOptions.Builder)DomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

