/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;

public class ListElasticsearchVersionsIterable
implements SdkIterable<ListElasticsearchVersionsResponse> {
    private final ElasticsearchClient client;
    private final ListElasticsearchVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListElasticsearchVersionsIterable(ElasticsearchClient client, ListElasticsearchVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListElasticsearchVersionsResponseFetcher();
    }

    public Iterator<ListElasticsearchVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListElasticsearchVersionsIterable resume(ListElasticsearchVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListElasticsearchVersionsIterable(this.client, (ListElasticsearchVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListElasticsearchVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListElasticsearchVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListElasticsearchVersionsResponseFetcher
    implements SyncPageFetcher<ListElasticsearchVersionsResponse> {
        private ListElasticsearchVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListElasticsearchVersionsResponse nextPage(ListElasticsearchVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchVersionsIterable.this.client.listElasticsearchVersions(ListElasticsearchVersionsIterable.this.firstRequest);
            }
            return ListElasticsearchVersionsIterable.this.client.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

