/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimitListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.StorageTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageType
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageType> {
    private final String storageTypeName;
    private final String storageSubTypeName;
    private final List<StorageTypeLimit> storageTypeLimits;

    private StorageType(BuilderImpl builder) {
        this.storageTypeName = builder.storageTypeName;
        this.storageSubTypeName = builder.storageSubTypeName;
        this.storageTypeLimits = builder.storageTypeLimits;
    }

    public String storageTypeName() {
        return this.storageTypeName;
    }

    public String storageSubTypeName() {
        return this.storageSubTypeName;
    }

    public List<StorageTypeLimit> storageTypeLimits() {
        return this.storageTypeLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSubTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeLimits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageType)) {
            return false;
        }
        StorageType other = (StorageType)obj;
        return Objects.equals(this.storageTypeName(), other.storageTypeName()) && Objects.equals(this.storageSubTypeName(), other.storageSubTypeName()) && Objects.equals(this.storageTypeLimits(), other.storageTypeLimits());
    }

    public String toString() {
        return ToString.builder((String)"StorageType").add("StorageTypeName", (Object)this.storageTypeName()).add("StorageSubTypeName", (Object)this.storageSubTypeName()).add("StorageTypeLimits", this.storageTypeLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageTypeName": {
                return Optional.of(clazz.cast(this.storageTypeName()));
            }
            case "StorageSubTypeName": {
                return Optional.of(clazz.cast(this.storageSubTypeName()));
            }
            case "StorageTypeLimits": {
                return Optional.of(clazz.cast(this.storageTypeLimits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageTypeName;
        private String storageSubTypeName;
        private List<StorageTypeLimit> storageTypeLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageType model) {
            this.storageTypeName(model.storageTypeName);
            this.storageSubTypeName(model.storageSubTypeName);
            this.storageTypeLimits(model.storageTypeLimits);
        }

        public final String getStorageTypeName() {
            return this.storageTypeName;
        }

        @Override
        public final Builder storageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
            return this;
        }

        public final void setStorageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
        }

        public final String getStorageSubTypeName() {
            return this.storageSubTypeName;
        }

        @Override
        public final Builder storageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
            return this;
        }

        public final void setStorageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
        }

        public final Collection<StorageTypeLimit.Builder> getStorageTypeLimits() {
            return this.storageTypeLimits != null ? (Collection)this.storageTypeLimits.stream().map(StorageTypeLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copy(storageTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(StorageTypeLimit ... storageTypeLimits) {
            this.storageTypeLimits(Arrays.asList(storageTypeLimits));
            return this;
        }

        public final void setStorageTypeLimits(Collection<StorageTypeLimit.BuilderImpl> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copyFromBuilder(storageTypeLimits);
        }

        public StorageType build() {
            return new StorageType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageType> {
        public Builder storageTypeName(String var1);

        public Builder storageSubTypeName(String var1);

        public Builder storageTypeLimits(Collection<StorageTypeLimit> var1);

        public Builder storageTypeLimits(StorageTypeLimit ... var1);
    }
}

