/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.DomainInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainInfo> {
    private final String domainName;

    private DomainInfo(BuilderImpl builder) {
        this.domainName = builder.domainName;
    }

    public String domainName() {
        return this.domainName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInfo)) {
            return false;
        }
        DomainInfo other = (DomainInfo)obj;
        return Objects.equals(this.domainName(), other.domainName());
    }

    public String toString() {
        return ToString.builder((String)"DomainInfo").add("DomainName", (Object)this.domainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInfo model) {
            this.domainName(model.domainName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public DomainInfo build() {
            return new DomainInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainInfo> {
        public Builder domainName(String var1);
    }
}

