/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.EndpointsMapCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchDomainStatusMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDomainStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDomainStatus> {
    private final String domainId;
    private final String domainName;
    private final String arn;
    private final Boolean created;
    private final Boolean deleted;
    private final String endpoint;
    private final Map<String, String> endpoints;
    private final Boolean processing;
    private final String elasticsearchVersion;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final String accessPolicies;
    private final SnapshotOptions snapshotOptions;
    private final VPCDerivedInfo vpcOptions;
    private final Map<String, String> advancedOptions;
    private final Map<String, LogPublishingOption> logPublishingOptions;

    private ElasticsearchDomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.processing = builder.processing;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean created() {
        return this.created;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Map<String, String> endpoints() {
        return this.endpoints;
    }

    public Boolean processing() {
        return this.processing;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCDerivedInfo vpcOptions() {
        return this.vpcOptions;
    }

    public Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public Map<LogType, LogPublishingOption> logPublishingOptions() {
        return TypeConverter.convert(this.logPublishingOptions, LogType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LogType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, LogPublishingOption> logPublishingOptionsStrings() {
        return this.logPublishingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.processing());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptionsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainStatus)) {
            return false;
        }
        ElasticsearchDomainStatus other = (ElasticsearchDomainStatus)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.processing(), other.processing()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptionsStrings(), other.logPublishingOptionsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchDomainStatus").add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("ARN", (Object)this.arn()).add("Created", (Object)this.created()).add("Deleted", (Object)this.deleted()).add("Endpoint", (Object)this.endpoint()).add("Endpoints", this.endpoints()).add("Processing", (Object)this.processing()).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("AdvancedOptions", this.advancedOptions()).add("LogPublishingOptions", this.logPublishingOptionsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.of(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "Deleted": {
                return Optional.of(clazz.cast(this.deleted()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "Endpoints": {
                return Optional.of(clazz.cast(this.endpoints()));
            }
            case "Processing": {
                return Optional.of(clazz.cast(this.processing()));
            }
            case "ElasticsearchVersion": {
                return Optional.of(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.of(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.of(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.of(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.of(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.of(clazz.cast(this.vpcOptions()));
            }
            case "AdvancedOptions": {
                return Optional.of(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.of(clazz.cast(this.logPublishingOptionsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDomainStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String domainName;
        private String arn;
        private Boolean created;
        private Boolean deleted;
        private String endpoint;
        private Map<String, String> endpoints;
        private Boolean processing;
        private String elasticsearchVersion;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private String accessPolicies;
        private SnapshotOptions snapshotOptions;
        private VPCDerivedInfo vpcOptions;
        private Map<String, String> advancedOptions;
        private Map<String, LogPublishingOption> logPublishingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainStatus model) {
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.arn(model.arn);
            this.created(model.created);
            this.deleted(model.deleted);
            this.endpoint(model.endpoint);
            this.endpoints(model.endpoints);
            this.processing(model.processing);
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptions(model.logPublishingOptions);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final Boolean getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Map<String, String> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
        }

        public final Boolean getProcessing() {
            return this.processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptions.Builder getEBSOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCDerivedInfo.Builder getVPCOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVPCOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final Map<String, String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            return this.logPublishingOptions != null ? CollectionUtils.mapValues(this.logPublishingOptions, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder logPublishingOptions(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        public ElasticsearchDomainStatus build() {
            return new ElasticsearchDomainStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDomainStatus> {
        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder arn(String var1);

        public Builder created(Boolean var1);

        public Builder deleted(Boolean var1);

        public Builder endpoint(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder processing(Boolean var1);

        public Builder elasticsearchVersion(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfig.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().apply(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().apply(ebsOptions)).build());
        }

        public Builder accessPolicies(String var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().apply(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfo var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfo)((VPCDerivedInfo.Builder)VPCDerivedInfo.builder().apply(vpcOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder logPublishingOptions(Map<String, LogPublishingOption> var1);
    }
}

