/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits;

@SdkInternalApi
public class InstanceCountLimitsMarshaller {
    private static final MarshallingInfo<Integer> MINIMUMINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumInstanceCount").build();
    private static final MarshallingInfo<Integer> MAXIMUMINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumInstanceCount").build();
    private static final InstanceCountLimitsMarshaller INSTANCE = new InstanceCountLimitsMarshaller();

    public static InstanceCountLimitsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceCountLimits instanceCountLimits, ProtocolMarshaller protocolMarshaller) {
        if (instanceCountLimits == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceCountLimits.minimumInstanceCount(), MINIMUMINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceCountLimits.maximumInstanceCount(), MAXIMUMINSTANCECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

