/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateElasticsearchDomainConfigRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
    private final String domainName;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final SnapshotOptions snapshotOptions;
    private final Map<String, String> advancedOptions;
    private final String accessPolicies;

    private UpdateElasticsearchDomainConfigRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.snapshotOptions = builder.snapshotOptions;
        this.advancedOptions = builder.advancedOptions;
        this.accessPolicies = builder.accessPolicies;
    }

    public String domainName() {
        return this.domainName;
    }

    public ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchClusterConfig() == null ? 0 : this.elasticsearchClusterConfig().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptions() == null ? 0 : this.ebsOptions().hashCode());
        hashCode = 31 * hashCode + (this.snapshotOptions() == null ? 0 : this.snapshotOptions().hashCode());
        hashCode = 31 * hashCode + (this.advancedOptions() == null ? 0 : this.advancedOptions().hashCode());
        hashCode = 31 * hashCode + (this.accessPolicies() == null ? 0 : this.accessPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateElasticsearchDomainConfigRequest)) {
            return false;
        }
        UpdateElasticsearchDomainConfigRequest other = (UpdateElasticsearchDomainConfigRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.elasticsearchClusterConfig() == null ^ this.elasticsearchClusterConfig() == null) {
            return false;
        }
        if (other.elasticsearchClusterConfig() != null && !other.elasticsearchClusterConfig().equals(this.elasticsearchClusterConfig())) {
            return false;
        }
        if (other.ebsOptions() == null ^ this.ebsOptions() == null) {
            return false;
        }
        if (other.ebsOptions() != null && !other.ebsOptions().equals(this.ebsOptions())) {
            return false;
        }
        if (other.snapshotOptions() == null ^ this.snapshotOptions() == null) {
            return false;
        }
        if (other.snapshotOptions() != null && !other.snapshotOptions().equals(this.snapshotOptions())) {
            return false;
        }
        if (other.advancedOptions() == null ^ this.advancedOptions() == null) {
            return false;
        }
        if (other.advancedOptions() != null && !other.advancedOptions().equals(this.advancedOptions())) {
            return false;
        }
        if (other.accessPolicies() == null ^ this.accessPolicies() == null) {
            return false;
        }
        return other.accessPolicies() == null || other.accessPolicies().equals(this.accessPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.elasticsearchClusterConfig() != null) {
            sb.append("ElasticsearchClusterConfig: ").append(this.elasticsearchClusterConfig()).append(",");
        }
        if (this.ebsOptions() != null) {
            sb.append("EBSOptions: ").append(this.ebsOptions()).append(",");
        }
        if (this.snapshotOptions() != null) {
            sb.append("SnapshotOptions: ").append(this.snapshotOptions()).append(",");
        }
        if (this.advancedOptions() != null) {
            sb.append("AdvancedOptions: ").append(this.advancedOptions()).append(",");
        }
        if (this.accessPolicies() != null) {
            sb.append("AccessPolicies: ").append(this.accessPolicies()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.of(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.of(clazz.cast(this.ebsOptions()));
            }
            case "SnapshotOptions": {
                return Optional.of(clazz.cast(this.snapshotOptions()));
            }
            case "AdvancedOptions": {
                return Optional.of(clazz.cast(this.advancedOptions()));
            }
            case "AccessPolicies": {
                return Optional.of(clazz.cast(this.accessPolicies()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private SnapshotOptions snapshotOptions;
        private Map<String, String> advancedOptions;
        private String accessPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateElasticsearchDomainConfigRequest model) {
            this.domainName(model.domainName);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.snapshotOptions(model.snapshotOptions);
            this.advancedOptions(model.advancedOptions);
            this.accessPolicies(model.accessPolicies);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptions.Builder getEBSOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final Map<String, String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public UpdateElasticsearchDomainConfigRequest build() {
            return new UpdateElasticsearchDomainConfigRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
        public Builder domainName(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        public Builder ebsOptions(EBSOptions var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        public Builder advancedOptions(Map<String, String> var1);

        public Builder accessPolicies(String var1);
    }
}

