/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.Limits;
import software.amazon.awssdk.services.elasticsearch.model.LimitsByRoleCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchInstanceTypeLimitsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
    private final Map<String, Limits> limitsByRole;

    private DescribeElasticsearchInstanceTypeLimitsResponse(BuilderImpl builder) {
        this.limitsByRole = builder.limitsByRole;
    }

    public Map<String, Limits> limitsByRole() {
        return this.limitsByRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.limitsByRole() == null ? 0 : this.limitsByRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsResponse)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsResponse other = (DescribeElasticsearchInstanceTypeLimitsResponse)((Object)obj);
        if (other.limitsByRole() == null ^ this.limitsByRole() == null) {
            return false;
        }
        return other.limitsByRole() == null || other.limitsByRole().equals(this.limitsByRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limitsByRole() != null) {
            sb.append("LimitsByRole: ").append(this.limitsByRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LimitsByRole": {
                return Optional.of(clazz.cast(this.limitsByRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Limits> limitsByRole;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsResponse model) {
            this.limitsByRole(model.limitsByRole);
        }

        public final Map<String, Limits.Builder> getLimitsByRole() {
            return this.limitsByRole != null ? CollectionUtils.mapValues(this.limitsByRole, Limits::toBuilder) : null;
        }

        @Override
        public final Builder limitsByRole(Map<String, Limits> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copy(limitsByRole);
            return this;
        }

        public final void setLimitsByRole(Map<String, Limits.BuilderImpl> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copyFromBuilder(limitsByRole);
        }

        public DescribeElasticsearchInstanceTypeLimitsResponse build() {
            return new DescribeElasticsearchInstanceTypeLimitsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
        public Builder limitsByRole(Map<String, Limits> var1);
    }
}

