/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;

@SdkInternalApi
public class ElasticsearchVersionStatusMarshaller {
    private static final MarshallingInfo<String> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final ElasticsearchVersionStatusMarshaller INSTANCE = new ElasticsearchVersionStatusMarshaller();

    public static ElasticsearchVersionStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchVersionStatus elasticsearchVersionStatus, ProtocolMarshaller protocolMarshaller) {
        if (elasticsearchVersionStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)elasticsearchVersionStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchVersionStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

