/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchClusterConfigStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchClusterConfigStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchClusterConfigStatus> {
    private final ElasticsearchClusterConfig options;
    private final OptionStatus status;

    private ElasticsearchClusterConfigStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public ElasticsearchClusterConfig options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfigStatus)) {
            return false;
        }
        ElasticsearchClusterConfigStatus other = (ElasticsearchClusterConfigStatus)obj;
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchClusterConfigStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ElasticsearchClusterConfig options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfigStatus model) {
            this.setOptions(model.options);
            this.setStatus(model.status);
        }

        public final ElasticsearchClusterConfig getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(ElasticsearchClusterConfig options) {
            this.options = options;
            return this;
        }

        public final void setOptions(ElasticsearchClusterConfig options) {
            this.options = options;
        }

        public final OptionStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus status) {
            this.status = status;
        }

        public ElasticsearchClusterConfigStatus build() {
            return new ElasticsearchClusterConfigStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchClusterConfigStatus> {
        public Builder options(ElasticsearchClusterConfig var1);

        public Builder status(OptionStatus var1);
    }
}

