/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchInstanceTypeLimitsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
    private final String domainName;
    private final String instanceType;
    private final String elasticsearchVersion;

    private DescribeElasticsearchInstanceTypeLimitsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.instanceType = builder.instanceType;
        this.elasticsearchVersion = builder.elasticsearchVersion;
    }

    public String domainName() {
        return this.domainName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchVersion() == null ? 0 : this.elasticsearchVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsRequest)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsRequest other = (DescribeElasticsearchInstanceTypeLimitsRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.elasticsearchVersion() == null ^ this.elasticsearchVersion() == null) {
            return false;
        }
        return other.elasticsearchVersion() == null || other.elasticsearchVersion().equals(this.elasticsearchVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.elasticsearchVersion() != null) {
            sb.append("ElasticsearchVersion: ").append(this.elasticsearchVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String instanceType;
        private String elasticsearchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsRequest model) {
            this.setDomainName(model.domainName);
            this.setInstanceType(model.instanceType);
            this.setElasticsearchVersion(model.elasticsearchVersion);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public DescribeElasticsearchInstanceTypeLimitsRequest build() {
            return new DescribeElasticsearchInstanceTypeLimitsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
        public Builder domainName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder elasticsearchVersion(String var1);
    }
}

