/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit;

public class AdditionalLimitUnmarshaller
implements Unmarshaller<AdditionalLimit, JsonUnmarshallerContext> {
    private static AdditionalLimitUnmarshaller INSTANCE;

    public AdditionalLimit unmarshall(JsonUnmarshallerContext context) throws Exception {
        AdditionalLimit.Builder additionalLimitBuilder = AdditionalLimit.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("LimitName", targetDepth)) {
                    context.nextToken();
                    additionalLimitBuilder.limitName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LimitValues", targetDepth)) {
                    context.nextToken();
                    additionalLimitBuilder.limitValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AdditionalLimit)additionalLimitBuilder.build();
    }

    public static AdditionalLimitUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AdditionalLimitUnmarshaller();
        }
        return INSTANCE;
    }
}

