/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimitListCopier;
import software.amazon.awssdk.services.elasticsearch.model.InstanceLimits;
import software.amazon.awssdk.services.elasticsearch.model.StorageType;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.LimitsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Limits
implements StructuredPojo,
ToCopyableBuilder<Builder, Limits> {
    private final List<StorageType> storageTypes;
    private final InstanceLimits instanceLimits;
    private final List<AdditionalLimit> additionalLimits;

    private Limits(BuilderImpl builder) {
        this.storageTypes = builder.storageTypes;
        this.instanceLimits = builder.instanceLimits;
        this.additionalLimits = builder.additionalLimits;
    }

    public List<StorageType> storageTypes() {
        return this.storageTypes;
    }

    public InstanceLimits instanceLimits() {
        return this.instanceLimits;
    }

    public List<AdditionalLimit> additionalLimits() {
        return this.additionalLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.storageTypes() == null ? 0 : this.storageTypes().hashCode());
        hashCode = 31 * hashCode + (this.instanceLimits() == null ? 0 : this.instanceLimits().hashCode());
        hashCode = 31 * hashCode + (this.additionalLimits() == null ? 0 : this.additionalLimits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits)obj;
        if (other.storageTypes() == null ^ this.storageTypes() == null) {
            return false;
        }
        if (other.storageTypes() != null && !other.storageTypes().equals(this.storageTypes())) {
            return false;
        }
        if (other.instanceLimits() == null ^ this.instanceLimits() == null) {
            return false;
        }
        if (other.instanceLimits() != null && !other.instanceLimits().equals(this.instanceLimits())) {
            return false;
        }
        if (other.additionalLimits() == null ^ this.additionalLimits() == null) {
            return false;
        }
        return other.additionalLimits() == null || other.additionalLimits().equals(this.additionalLimits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storageTypes() != null) {
            sb.append("StorageTypes: ").append(this.storageTypes()).append(",");
        }
        if (this.instanceLimits() != null) {
            sb.append("InstanceLimits: ").append(this.instanceLimits()).append(",");
        }
        if (this.additionalLimits() != null) {
            sb.append("AdditionalLimits: ").append(this.additionalLimits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StorageType> storageTypes;
        private InstanceLimits instanceLimits;
        private List<AdditionalLimit> additionalLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(Limits model) {
            this.setStorageTypes(model.storageTypes);
            this.setInstanceLimits(model.instanceLimits);
            this.setAdditionalLimits(model.additionalLimits);
        }

        public final Collection<StorageType> getStorageTypes() {
            return this.storageTypes;
        }

        @Override
        public final Builder storageTypes(Collection<StorageType> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copy(storageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypes(StorageType ... storageTypes) {
            this.storageTypes(Arrays.asList(storageTypes));
            return this;
        }

        public final void setStorageTypes(Collection<StorageType> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copy(storageTypes);
        }

        @SafeVarargs
        public final void setStorageTypes(StorageType ... storageTypes) {
            this.storageTypes(Arrays.asList(storageTypes));
        }

        public final InstanceLimits getInstanceLimits() {
            return this.instanceLimits;
        }

        @Override
        public final Builder instanceLimits(InstanceLimits instanceLimits) {
            this.instanceLimits = instanceLimits;
            return this;
        }

        public final void setInstanceLimits(InstanceLimits instanceLimits) {
            this.instanceLimits = instanceLimits;
        }

        public final Collection<AdditionalLimit> getAdditionalLimits() {
            return this.additionalLimits;
        }

        @Override
        public final Builder additionalLimits(Collection<AdditionalLimit> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copy(additionalLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLimits(AdditionalLimit ... additionalLimits) {
            this.additionalLimits(Arrays.asList(additionalLimits));
            return this;
        }

        public final void setAdditionalLimits(Collection<AdditionalLimit> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copy(additionalLimits);
        }

        @SafeVarargs
        public final void setAdditionalLimits(AdditionalLimit ... additionalLimits) {
            this.additionalLimits(Arrays.asList(additionalLimits));
        }

        public Limits build() {
            return new Limits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Limits> {
        public Builder storageTypes(Collection<StorageType> var1);

        public Builder storageTypes(StorageType ... var1);

        public Builder instanceLimits(InstanceLimits var1);

        public Builder additionalLimits(Collection<AdditionalLimit> var1);

        public Builder additionalLimits(AdditionalLimit ... var1);
    }
}

