/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchDomainConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDomainConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDomainConfig> {
    private final ElasticsearchVersionStatus elasticsearchVersion;
    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final SnapshotOptionsStatus snapshotOptions;
    private final AdvancedOptionsStatus advancedOptions;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.advancedOptions = builder.advancedOptions;
    }

    public ElasticsearchVersionStatus elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticsearchVersion() == null ? 0 : this.elasticsearchVersion().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchClusterConfig() == null ? 0 : this.elasticsearchClusterConfig().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptions() == null ? 0 : this.ebsOptions().hashCode());
        hashCode = 31 * hashCode + (this.accessPolicies() == null ? 0 : this.accessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.snapshotOptions() == null ? 0 : this.snapshotOptions().hashCode());
        hashCode = 31 * hashCode + (this.advancedOptions() == null ? 0 : this.advancedOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig)obj;
        if (other.elasticsearchVersion() == null ^ this.elasticsearchVersion() == null) {
            return false;
        }
        if (other.elasticsearchVersion() != null && !other.elasticsearchVersion().equals(this.elasticsearchVersion())) {
            return false;
        }
        if (other.elasticsearchClusterConfig() == null ^ this.elasticsearchClusterConfig() == null) {
            return false;
        }
        if (other.elasticsearchClusterConfig() != null && !other.elasticsearchClusterConfig().equals(this.elasticsearchClusterConfig())) {
            return false;
        }
        if (other.ebsOptions() == null ^ this.ebsOptions() == null) {
            return false;
        }
        if (other.ebsOptions() != null && !other.ebsOptions().equals(this.ebsOptions())) {
            return false;
        }
        if (other.accessPolicies() == null ^ this.accessPolicies() == null) {
            return false;
        }
        if (other.accessPolicies() != null && !other.accessPolicies().equals(this.accessPolicies())) {
            return false;
        }
        if (other.snapshotOptions() == null ^ this.snapshotOptions() == null) {
            return false;
        }
        if (other.snapshotOptions() != null && !other.snapshotOptions().equals(this.snapshotOptions())) {
            return false;
        }
        if (other.advancedOptions() == null ^ this.advancedOptions() == null) {
            return false;
        }
        return other.advancedOptions() == null || other.advancedOptions().equals(this.advancedOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.elasticsearchVersion() != null) {
            sb.append("ElasticsearchVersion: ").append(this.elasticsearchVersion()).append(",");
        }
        if (this.elasticsearchClusterConfig() != null) {
            sb.append("ElasticsearchClusterConfig: ").append(this.elasticsearchClusterConfig()).append(",");
        }
        if (this.ebsOptions() != null) {
            sb.append("EBSOptions: ").append(this.ebsOptions()).append(",");
        }
        if (this.accessPolicies() != null) {
            sb.append("AccessPolicies: ").append(this.accessPolicies()).append(",");
        }
        if (this.snapshotOptions() != null) {
            sb.append("SnapshotOptions: ").append(this.snapshotOptions()).append(",");
        }
        if (this.advancedOptions() != null) {
            sb.append("AdvancedOptions: ").append(this.advancedOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDomainConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;
        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private SnapshotOptionsStatus snapshotOptions;
        private AdvancedOptionsStatus advancedOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            this.setElasticsearchVersion(model.elasticsearchVersion);
            this.setElasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.setEBSOptions(model.ebsOptions);
            this.setAccessPolicies(model.accessPolicies);
            this.setSnapshotOptions(model.snapshotOptions);
            this.setAdvancedOptions(model.advancedOptions);
        }

        public final ElasticsearchVersionStatus getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final ElasticsearchClusterConfigStatus getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
        }

        public final EBSOptionsStatus getEBSOptions() {
            return this.ebsOptions;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
        }

        public final AccessPoliciesStatus getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final SnapshotOptionsStatus getSnapshotOptions() {
            return this.snapshotOptions;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
        }

        public final AdvancedOptionsStatus getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
        }

        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        public Builder elasticsearchVersion(ElasticsearchVersionStatus var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus var1);

        public Builder ebsOptions(EBSOptionsStatus var1);

        public Builder accessPolicies(AccessPoliciesStatus var1);

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        public Builder advancedOptions(AdvancedOptionsStatus var1);
    }
}

