/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.services.elasticsearch.transform.AdvancedOptionsStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AdvancedOptionsStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AdvancedOptionsStatus> {
    private final Map<String, String> options;
    private final OptionStatus status;

    private AdvancedOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedOptionsStatus)) {
            return false;
        }
        AdvancedOptionsStatus other = (AdvancedOptionsStatus)obj;
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdvancedOptionsStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, String> options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedOptionsStatus model) {
            this.setOptions(model.options);
            this.setStatus(model.status);
        }

        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = AdvancedOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = AdvancedOptionsCopier.copy(options);
        }

        public final OptionStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus status) {
            this.status = status;
        }

        public AdvancedOptionsStatus build() {
            return new AdvancedOptionsStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AdvancedOptionsStatus> {
        public Builder options(Map<String, String> var1);

        public Builder status(OptionStatus var1);
    }
}

