/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigResponseUnmarshaller;

@SdkInternalApi
final class DefaultElasticsearchClient
implements ElasticsearchClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultElasticsearchClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException, ValidationException, InternalException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AddTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateElasticsearchDomainResponse createElasticsearchDomain(CreateElasticsearchDomainRequest createElasticsearchDomainRequest) throws BaseException, DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException, ResourceAlreadyExistsException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateElasticsearchDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateElasticsearchDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createElasticsearchDomainRequest).withMarshaller((Marshaller)new CreateElasticsearchDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteElasticsearchDomainResponse deleteElasticsearchDomain(DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteElasticsearchDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteElasticsearchDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteElasticsearchDomainRequest).withMarshaller((Marshaller)new DeleteElasticsearchDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeElasticsearchDomainResponse describeElasticsearchDomain(DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeElasticsearchDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeElasticsearchDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeElasticsearchDomainRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeElasticsearchDomainConfigResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeElasticsearchDomainConfigResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeElasticsearchDomainConfigRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainConfigRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeElasticsearchDomainsResponse describeElasticsearchDomains(DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) throws BaseException, InternalException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeElasticsearchDomainsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeElasticsearchDomainsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeElasticsearchDomainsRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeElasticsearchInstanceTypeLimitsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeElasticsearchInstanceTypeLimitsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeElasticsearchInstanceTypeLimitsRequest).withMarshaller((Marshaller)new DescribeElasticsearchInstanceTypeLimitsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListDomainNamesResponse listDomainNames() throws BaseException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        return this.listDomainNames((ListDomainNamesRequest)((Object)ListDomainNamesRequest.builder().build()));
    }

    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListDomainNamesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListDomainNamesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listDomainNamesRequest).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListElasticsearchInstanceTypesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListElasticsearchInstanceTypesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listElasticsearchInstanceTypesRequest).withMarshaller((Marshaller)new ListElasticsearchInstanceTypesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListElasticsearchVersionsResponse listElasticsearchVersions() throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        return this.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsRequest.builder().build()));
    }

    @Override
    public ListElasticsearchVersionsResponse listElasticsearchVersions(ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListElasticsearchVersionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListElasticsearchVersionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listElasticsearchVersionsRequest).withMarshaller((Marshaller)new ListElasticsearchVersionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException, ValidationException, InternalException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException, InternalException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RemoveTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, ElasticsearchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateElasticsearchDomainConfigResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateElasticsearchDomainConfigResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateElasticsearchDomainConfigRequest).withMarshaller((Marshaller)new UpdateElasticsearchDomainConfigRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(ElasticsearchException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DisabledOperationException").withModeledClass(DisabledOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BaseException").withModeledClass(BaseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withModeledClass(InternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTypeException").withModeledClass(InvalidTypeException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

