/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy used for SSL negotiation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SslPolicy implements SdkPojo, Serializable, ToCopyableBuilder<SslPolicy.Builder, SslPolicy> {
    private static final SdkField<List<String>> SSL_PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SslProtocols")
            .getter(getter(SslPolicy::sslProtocols))
            .setter(setter(Builder::sslProtocols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProtocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Cipher>> CIPHERS_FIELD = SdkField
            .<List<Cipher>> builder(MarshallingType.LIST)
            .memberName("Ciphers")
            .getter(getter(SslPolicy::ciphers))
            .setter(setter(Builder::ciphers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ciphers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cipher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cipher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SslPolicy::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> SUPPORTED_LOAD_BALANCER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedLoadBalancerTypes")
            .getter(getter(SslPolicy::supportedLoadBalancerTypes))
            .setter(setter(Builder::supportedLoadBalancerTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedLoadBalancerTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSL_PROTOCOLS_FIELD,
            CIPHERS_FIELD, NAME_FIELD, SUPPORTED_LOAD_BALANCER_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> sslProtocols;

    private final List<Cipher> ciphers;

    private final String name;

    private final List<String> supportedLoadBalancerTypes;

    private SslPolicy(BuilderImpl builder) {
        this.sslProtocols = builder.sslProtocols;
        this.ciphers = builder.ciphers;
        this.name = builder.name;
        this.supportedLoadBalancerTypes = builder.supportedLoadBalancerTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SslProtocols property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSslProtocols() {
        return sslProtocols != null && !(sslProtocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSslProtocols} method.
     * </p>
     * 
     * @return The protocols.
     */
    public final List<String> sslProtocols() {
        return sslProtocols;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ciphers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCiphers() {
        return ciphers != null && !(ciphers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ciphers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCiphers} method.
     * </p>
     * 
     * @return The ciphers.
     */
    public final List<Cipher> ciphers() {
        return ciphers;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedLoadBalancerTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedLoadBalancerTypes() {
        return supportedLoadBalancerTypes != null && !(supportedLoadBalancerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedLoadBalancerTypes} method.
     * </p>
     * 
     * @return The supported load balancers.
     */
    public final List<String> supportedLoadBalancerTypes() {
        return supportedLoadBalancerTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSslProtocols() ? sslProtocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCiphers() ? ciphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedLoadBalancerTypes() ? supportedLoadBalancerTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy) obj;
        return hasSslProtocols() == other.hasSslProtocols() && Objects.equals(sslProtocols(), other.sslProtocols())
                && hasCiphers() == other.hasCiphers() && Objects.equals(ciphers(), other.ciphers())
                && Objects.equals(name(), other.name())
                && hasSupportedLoadBalancerTypes() == other.hasSupportedLoadBalancerTypes()
                && Objects.equals(supportedLoadBalancerTypes(), other.supportedLoadBalancerTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SslPolicy").add("SslProtocols", hasSslProtocols() ? sslProtocols() : null)
                .add("Ciphers", hasCiphers() ? ciphers() : null).add("Name", name())
                .add("SupportedLoadBalancerTypes", hasSupportedLoadBalancerTypes() ? supportedLoadBalancerTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SslProtocols":
            return Optional.ofNullable(clazz.cast(sslProtocols()));
        case "Ciphers":
            return Optional.ofNullable(clazz.cast(ciphers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SupportedLoadBalancerTypes":
            return Optional.ofNullable(clazz.cast(supportedLoadBalancerTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SslProtocols", SSL_PROTOCOLS_FIELD);
        map.put("Ciphers", CIPHERS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SupportedLoadBalancerTypes", SUPPORTED_LOAD_BALANCER_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SslPolicy, T> g) {
        return obj -> g.apply((SslPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SslPolicy> {
        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param sslProtocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProtocols(Collection<String> sslProtocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param sslProtocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProtocols(String... sslProtocols);

        /**
         * <p>
         * The ciphers.
         * </p>
         * 
         * @param ciphers
         *        The ciphers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphers(Collection<Cipher> ciphers);

        /**
         * <p>
         * The ciphers.
         * </p>
         * 
         * @param ciphers
         *        The ciphers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphers(Cipher... ciphers);

        /**
         * <p>
         * The ciphers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher.Builder#build()} is called
         * immediately and its result is passed to {@link #ciphers(List<Cipher>)}.
         * 
         * @param ciphers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ciphers(java.util.Collection<Cipher>)
         */
        Builder ciphers(Consumer<Cipher.Builder>... ciphers);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param name
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The supported load balancers.
         * </p>
         * 
         * @param supportedLoadBalancerTypes
         *        The supported load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLoadBalancerTypes(Collection<String> supportedLoadBalancerTypes);

        /**
         * <p>
         * The supported load balancers.
         * </p>
         * 
         * @param supportedLoadBalancerTypes
         *        The supported load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedLoadBalancerTypes(String... supportedLoadBalancerTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> sslProtocols = DefaultSdkAutoConstructList.getInstance();

        private List<Cipher> ciphers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<String> supportedLoadBalancerTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SslPolicy model) {
            sslProtocols(model.sslProtocols);
            ciphers(model.ciphers);
            name(model.name);
            supportedLoadBalancerTypes(model.supportedLoadBalancerTypes);
        }

        public final Collection<String> getSslProtocols() {
            if (sslProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return sslProtocols;
        }

        public final void setSslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
        }

        @Override
        public final Builder sslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslProtocols(String... sslProtocols) {
            sslProtocols(Arrays.asList(sslProtocols));
            return this;
        }

        public final List<Cipher.Builder> getCiphers() {
            List<Cipher.Builder> result = CiphersCopier.copyToBuilder(this.ciphers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCiphers(Collection<Cipher.BuilderImpl> ciphers) {
            this.ciphers = CiphersCopier.copyFromBuilder(ciphers);
        }

        @Override
        public final Builder ciphers(Collection<Cipher> ciphers) {
            this.ciphers = CiphersCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Cipher... ciphers) {
            ciphers(Arrays.asList(ciphers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Consumer<Cipher.Builder>... ciphers) {
            ciphers(Stream.of(ciphers).map(c -> Cipher.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSupportedLoadBalancerTypes() {
            if (supportedLoadBalancerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedLoadBalancerTypes;
        }

        public final void setSupportedLoadBalancerTypes(Collection<String> supportedLoadBalancerTypes) {
            this.supportedLoadBalancerTypes = ListOfStringCopier.copy(supportedLoadBalancerTypes);
        }

        @Override
        public final Builder supportedLoadBalancerTypes(Collection<String> supportedLoadBalancerTypes) {
            this.supportedLoadBalancerTypes = ListOfStringCopier.copy(supportedLoadBalancerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLoadBalancerTypes(String... supportedLoadBalancerTypes) {
            supportedLoadBalancerTypes(Arrays.asList(supportedLoadBalancerTypes));
            return this;
        }

        @Override
        public SslPolicy build() {
            return new SslPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
