/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancersRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeLoadBalancersRequest> {
    private static final SdkField<List<String>> LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerArns").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::loadBalancerArns)).setter(DescribeLoadBalancersRequest.setter(Builder::loadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::names)).setter(DescribeLoadBalancersRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::marker)).setter(DescribeLoadBalancersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(DescribeLoadBalancersRequest.getter(DescribeLoadBalancersRequest::pageSize)).setter(DescribeLoadBalancersRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARNS_FIELD, NAMES_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLoadBalancersRequest.memberNameToFieldInitializer();
    private final List<String> loadBalancerArns;
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeLoadBalancersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArns = builder.loadBalancerArns;
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public final boolean hasLoadBalancerArns() {
        return this.loadBalancerArns != null && !(this.loadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> loadBalancerArns() {
        return this.loadBalancerArns;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerArns() ? this.loadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersRequest)) {
            return false;
        }
        DescribeLoadBalancersRequest other = (DescribeLoadBalancersRequest)((Object)obj);
        return this.hasLoadBalancerArns() == other.hasLoadBalancerArns() && Objects.equals(this.loadBalancerArns(), other.loadBalancerArns()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoadBalancersRequest").add("LoadBalancerArns", this.hasLoadBalancerArns() ? this.loadBalancerArns() : null).add("Names", this.hasNames() ? this.names() : null).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArns()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerArns", LOAD_BALANCER_ARNS_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancersRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private List<String> loadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersRequest model) {
            super(model);
            this.loadBalancerArns(model.loadBalancerArns);
            this.names(model.names);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final Collection<String> getLoadBalancerArns() {
            if (this.loadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerArns;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = LoadBalancerNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = LoadBalancerNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancersRequest build() {
            return new DescribeLoadBalancersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancersRequest> {
        public Builder loadBalancerArns(Collection<String> var1);

        public Builder loadBalancerArns(String ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

