/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustStoreRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<CreateTrustStoreRequest.Builder, CreateTrustStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTrustStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3Bucket")
            .getter(getter(CreateTrustStoreRequest::caCertificatesBundleS3Bucket))
            .setter(setter(Builder::caCertificatesBundleS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Bucket")
                    .build()).build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3Key").getter(getter(CreateTrustStoreRequest::caCertificatesBundleS3Key))
            .setter(setter(Builder::caCertificatesBundleS3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Key").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3ObjectVersion")
            .getter(getter(CreateTrustStoreRequest::caCertificatesBundleS3ObjectVersion))
            .setter(setter(Builder::caCertificatesBundleS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CaCertificatesBundleS3ObjectVersion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrustStoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD, CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD,
            CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD, TAGS_FIELD));

    private final String name;

    private final String caCertificatesBundleS3Bucket;

    private final String caCertificatesBundleS3Key;

    private final String caCertificatesBundleS3ObjectVersion;

    private final List<Tag> tags;

    private CreateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.caCertificatesBundleS3Bucket = builder.caCertificatesBundleS3Bucket;
        this.caCertificatesBundleS3Key = builder.caCertificatesBundleS3Key;
        this.caCertificatesBundleS3ObjectVersion = builder.caCertificatesBundleS3ObjectVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the trust store.
     * </p>
     * <p>
     * This name must be unique per region and cannot be changed after creation.
     * </p>
     * 
     * @return The name of the trust store.</p>
     *         <p>
     *         This name must be unique per region and cannot be changed after creation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the ca certificates bundle.
     * </p>
     * 
     * @return The Amazon S3 bucket for the ca certificates bundle.
     */
    public final String caCertificatesBundleS3Bucket() {
        return caCertificatesBundleS3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 path for the ca certificates bundle.
     * </p>
     * 
     * @return The Amazon S3 path for the ca certificates bundle.
     */
    public final String caCertificatesBundleS3Key() {
        return caCertificatesBundleS3Key;
    }

    /**
     * <p>
     * The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
     * </p>
     * 
     * @return The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
     */
    public final String caCertificatesBundleS3ObjectVersion() {
        return caCertificatesBundleS3ObjectVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the trust store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the trust store.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustStoreRequest)) {
            return false;
        }
        CreateTrustStoreRequest other = (CreateTrustStoreRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(caCertificatesBundleS3Bucket(), other.caCertificatesBundleS3Bucket())
                && Objects.equals(caCertificatesBundleS3Key(), other.caCertificatesBundleS3Key())
                && Objects.equals(caCertificatesBundleS3ObjectVersion(), other.caCertificatesBundleS3ObjectVersion())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustStoreRequest").add("Name", name())
                .add("CaCertificatesBundleS3Bucket", caCertificatesBundleS3Bucket())
                .add("CaCertificatesBundleS3Key", caCertificatesBundleS3Key())
                .add("CaCertificatesBundleS3ObjectVersion", caCertificatesBundleS3ObjectVersion())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CaCertificatesBundleS3Bucket":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3Bucket()));
        case "CaCertificatesBundleS3Key":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3Key()));
        case "CaCertificatesBundleS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3ObjectVersion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustStoreRequest, T> g) {
        return obj -> g.apply((CreateTrustStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrustStoreRequest> {
        /**
         * <p>
         * The name of the trust store.
         * </p>
         * <p>
         * This name must be unique per region and cannot be changed after creation.
         * </p>
         * 
         * @param name
         *        The name of the trust store.</p>
         *        <p>
         *        This name must be unique per region and cannot be changed after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon S3 bucket for the ca certificates bundle.
         * </p>
         * 
         * @param caCertificatesBundleS3Bucket
         *        The Amazon S3 bucket for the ca certificates bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket);

        /**
         * <p>
         * The Amazon S3 path for the ca certificates bundle.
         * </p>
         * 
         * @param caCertificatesBundleS3Key
         *        The Amazon S3 path for the ca certificates bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key);

        /**
         * <p>
         * The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
         * </p>
         * 
         * @param caCertificatesBundleS3ObjectVersion
         *        The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion);

        /**
         * <p>
         * The tags to assign to the trust store.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to assign to the trust store.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to assign to the trust store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String name;

        private String caCertificatesBundleS3Bucket;

        private String caCertificatesBundleS3Key;

        private String caCertificatesBundleS3ObjectVersion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustStoreRequest model) {
            super(model);
            name(model.name);
            caCertificatesBundleS3Bucket(model.caCertificatesBundleS3Bucket);
            caCertificatesBundleS3Key(model.caCertificatesBundleS3Key);
            caCertificatesBundleS3ObjectVersion(model.caCertificatesBundleS3ObjectVersion);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCaCertificatesBundleS3Bucket() {
            return caCertificatesBundleS3Bucket;
        }

        public final void setCaCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
        }

        @Override
        public final Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
            return this;
        }

        public final String getCaCertificatesBundleS3Key() {
            return caCertificatesBundleS3Key;
        }

        public final void setCaCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
        }

        @Override
        public final Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
            return this;
        }

        public final String getCaCertificatesBundleS3ObjectVersion() {
            return caCertificatesBundleS3ObjectVersion;
        }

        public final void setCaCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
        }

        @Override
        public final Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustStoreRequest build() {
            return new CreateTrustStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
