/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStringConditionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStringConditionConfig> {
    private static final SdkField<List<QueryStringKeyValuePair>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(QueryStringConditionConfig.getter(QueryStringConditionConfig::values)).setter(QueryStringConditionConfig.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryStringKeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<QueryStringKeyValuePair> values;

    private QueryStringConditionConfig(BuilderImpl builder) {
        this.values = builder.values;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<QueryStringKeyValuePair> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStringConditionConfig)) {
            return false;
        }
        QueryStringConditionConfig other = (QueryStringConditionConfig)obj;
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStringConditionConfig").add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryStringConditionConfig, T> g) {
        return obj -> g.apply((QueryStringConditionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<QueryStringKeyValuePair> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStringConditionConfig model) {
            this.values(model.values);
        }

        public final Collection<QueryStringKeyValuePair.Builder> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values != null ? (Collection)this.values.stream().map(QueryStringKeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder values(Collection<QueryStringKeyValuePair> values) {
            this.values = QueryStringKeyValuePairListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(QueryStringKeyValuePair ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<QueryStringKeyValuePair.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (QueryStringKeyValuePair)((QueryStringKeyValuePair.Builder)QueryStringKeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValues(Collection<QueryStringKeyValuePair.BuilderImpl> values) {
            this.values = QueryStringKeyValuePairListCopier.copyFromBuilder(values);
        }

        public QueryStringConditionConfig build() {
            return new QueryStringConditionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStringConditionConfig> {
        public Builder values(Collection<QueryStringKeyValuePair> var1);

        public Builder values(QueryStringKeyValuePair ... var1);

        public Builder values(Consumer<QueryStringKeyValuePair.Builder> ... var1);
    }
}

