/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Rule::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Rule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<List<RuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<RuleCondition>> builder(MarshallingType.LIST)
            .getter(getter(Rule::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .getter(getter(Rule::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Rule::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            PRIORITY_FIELD, CONDITIONS_FIELD, ACTIONS_FIELD, IS_DEFAULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleArn;

    private final String priority;

    private final List<RuleCondition> conditions;

    private final List<Action> actions;

    private final Boolean isDefault;

    private Rule(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.priority = builder.priority;
        this.conditions = builder.conditions;
        this.actions = builder.actions;
        this.isDefault = builder.isDefault;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The priority.
     * </p>
     * 
     * @return The priority.
     */
    public String priority() {
        return priority;
    }

    /**
     * Returns true if the Conditions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions. Each rule can include zero or one of the following conditions: <code>http-request-method</code>,
     * <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>, and zero or more of the
     * following conditions: <code>http-header</code> and <code>query-string</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The conditions. Each rule can include zero or one of the following conditions:
     *         <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
     *         <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
     *         <code>query-string</code>.
     */
    public List<RuleCondition> conditions() {
        return conditions;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     *         <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
     */
    public List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * Indicates whether this is the default rule.
     * </p>
     * 
     * @return Indicates whether this is the default rule.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(priority(), other.priority())
                && Objects.equals(conditions(), other.conditions()) && Objects.equals(actions(), other.actions())
                && Objects.equals(isDefault(), other.isDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Rule").add("RuleArn", ruleArn()).add("Priority", priority()).add("Conditions", conditions())
                .add("Actions", actions()).add("IsDefault", isDefault()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The priority.
         * </p>
         * 
         * @param priority
         *        The priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(String priority);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<RuleCondition> conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(RuleCondition... conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleCondition>.Builder} avoiding the need
         * to create one manually via {@link List<RuleCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #conditions(List<RuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<RuleCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<RuleCondition>)
         */
        Builder conditions(Consumer<RuleCondition.Builder>... conditions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>redirect</code>, or <code>fixed-response</code>, and it must be the last
         *        action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>redirect</code>, or <code>fixed-response</code>, and it must be the last
         *        action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * Indicates whether this is the default rule.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String priority;

        private List<RuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            ruleArn(model.ruleArn);
            priority(model.priority);
            conditions(model.conditions);
            actions(model.actions);
            isDefault(model.isDefault);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final String getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final Collection<RuleCondition.Builder> getConditions() {
            return conditions != null ? conditions.stream().map(RuleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> RuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        public final Collection<Action.Builder> getActions() {
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
