/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpRequestMethodEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpRequestMethodListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRequestMethodConditionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRequestMethodConditionConfig> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HttpRequestMethodConditionConfig.getter(HttpRequestMethodConditionConfig::valuesAsStrings)).setter(HttpRequestMethodConditionConfig.setter(Builder::valuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> values;

    private HttpRequestMethodConditionConfig(BuilderImpl builder) {
        this.values = builder.values;
    }

    public List<HttpRequestMethodEnum> values() {
        return TypeConverter.convert(this.values, HttpRequestMethodEnum::fromValue);
    }

    public List<String> valuesAsStrings() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRequestMethodConditionConfig)) {
            return false;
        }
        HttpRequestMethodConditionConfig other = (HttpRequestMethodConditionConfig)obj;
        return Objects.equals(this.valuesAsStrings(), other.valuesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"HttpRequestMethodConditionConfig").add("Values", this.valuesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.valuesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRequestMethodConditionConfig, T> g) {
        return obj -> g.apply((HttpRequestMethodConditionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRequestMethodConditionConfig model) {
            this.valuesWithStrings(model.values);
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder valuesWithStrings(Collection<String> values) {
            this.values = HttpRequestMethodListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesWithStrings(String ... values) {
            this.valuesWithStrings(Arrays.asList(values));
            return this;
        }

        @Override
        public final Builder values(Collection<HttpRequestMethodEnum> values) {
            this.values = HttpRequestMethodListCopier.copyEnumToString(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(HttpRequestMethodEnum ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = HttpRequestMethodListCopier.copy(values);
        }

        public HttpRequestMethodConditionConfig build() {
            return new HttpRequestMethodConditionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRequestMethodConditionConfig> {
        public Builder valuesWithStrings(Collection<String> var1);

        public Builder valuesWithStrings(String ... var1);

        public Builder values(Collection<HttpRequestMethodEnum> var1);

        public Builder values(HttpRequestMethodEnum ... var1);
    }
}

