/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;

public class DescribeListenersIterable
implements SdkIterable<DescribeListenersResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeListenersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeListenersIterable(ElasticLoadBalancingV2Client client, DescribeListenersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeListenersResponseFetcher();
    }

    public Iterator<DescribeListenersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Listener> listeners() {
        Function<DescribeListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.listeners() != null) {
                return response.listeners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeListenersIterable resume(DescribeListenersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeListenersIterable(this.client, (DescribeListenersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeListenersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeListenersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeListenersResponseFetcher
    implements SyncPageFetcher<DescribeListenersResponse> {
        private DescribeListenersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeListenersResponse nextPage(DescribeListenersResponse previousPage) {
            if (previousPage == null) {
                return DescribeListenersIterable.this.client.describeListeners(DescribeListenersIterable.this.firstRequest);
            }
            return DescribeListenersIterable.this.client.describeListeners((DescribeListenersRequest)((Object)DescribeListenersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

