/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<Tag> list;
        List<String> securityGroupsList;
        List<SubnetMapping> subnetMappingsList;
        List<String> subnetsList;
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createLoadBalancerRequest.name()));
        }
        if ((subnetsList = createLoadBalancerRequest.subnets()) != null) {
            if (!subnetsList.isEmpty()) {
                int subnetsListIndex = 1;
                for (String string : subnetsList) {
                    if (string != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)string));
                    }
                    ++subnetsListIndex;
                }
            } else {
                request.addParameter("Subnets", "");
            }
        }
        if ((subnetMappingsList = createLoadBalancerRequest.subnetMappings()) != null) {
            if (!subnetMappingsList.isEmpty()) {
                int subnetMappingsListIndex = 1;
                for (SubnetMapping subnetMapping : subnetMappingsList) {
                    if (subnetMapping.subnetId() != null) {
                        request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringUtils.fromString((String)subnetMapping.subnetId()));
                    }
                    if (subnetMapping.allocationId() != null) {
                        request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringUtils.fromString((String)subnetMapping.allocationId()));
                    }
                    ++subnetMappingsListIndex;
                }
            } else {
                request.addParameter("SubnetMappings", "");
            }
        }
        if ((securityGroupsList = createLoadBalancerRequest.securityGroups()) != null) {
            if (!securityGroupsList.isEmpty()) {
                boolean bl = true;
                for (String securityGroupsListValue : securityGroupsList) {
                    void var6_12;
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + (int)var6_12, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("SecurityGroups", "");
            }
        }
        if (createLoadBalancerRequest.schemeString() != null) {
            request.addParameter("Scheme", StringUtils.fromString((String)createLoadBalancerRequest.schemeString()));
        }
        if ((list = createLoadBalancerRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var7_18;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var7_18 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var7_18 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createLoadBalancerRequest.typeString() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createLoadBalancerRequest.typeString()));
        }
        if (createLoadBalancerRequest.ipAddressTypeString() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString((String)createLoadBalancerRequest.ipAddressTypeString()));
        }
        return request;
    }
}

