/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyLoadBalancerAttributesResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, ModifyLoadBalancerAttributesResponse> {
    private final List<LoadBalancerAttribute> attributes;

    private ModifyLoadBalancerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public List<LoadBalancerAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesResponse)) {
            return false;
        }
        ModifyLoadBalancerAttributesResponse other = (ModifyLoadBalancerAttributesResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"ModifyLoadBalancerAttributesResponse").add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<LoadBalancerAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesResponse model) {
            this.attributes(model.attributes);
        }

        public final Collection<LoadBalancerAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(LoadBalancerAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<LoadBalancerAttribute> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(LoadBalancerAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<LoadBalancerAttribute.BuilderImpl> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public ModifyLoadBalancerAttributesResponse build() {
            return new ModifyLoadBalancerAttributesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, ModifyLoadBalancerAttributesResponse> {
        public Builder attributes(Collection<LoadBalancerAttribute> var1);

        public Builder attributes(LoadBalancerAttribute ... var1);
    }
}

